/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.sse.internal;

import org.eclipse.smarthome.io.rest.sse.internal.async.BlockingAsyncFeature;
import org.eclipse.smarthome.io.rest.sse.internal.util.SseUtil;
import org.glassfish.jersey.media.sse.SseFeature;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseActivator
implements BundleActivator {
    private final Logger logger = LoggerFactory.getLogger(SseActivator.class);
    private static BundleContext context;
    private ServiceRegistration<?> sseFeatureRegistration;
    private ServiceRegistration<?> blockingAsyncFeatureRegistration;

    public void start(BundleContext bc) throws Exception {
        context = bc;
        String featureName = SseFeature.class.getName();
        if (bc.getServiceReference(featureName) == null) {
            this.sseFeatureRegistration = bc.registerService(featureName, (Object)new SseFeature(), null);
            this.logger.debug("SSE API - SseFeature registered.");
        }
        if (!SseUtil.SERVLET3_SUPPORT) {
            this.blockingAsyncFeatureRegistration = bc.registerService(BlockingAsyncFeature.class.getName(), (Object)new BlockingAsyncFeature(), null);
            this.logger.debug("SSE API - SSE BlockingAsyncFeature registered.");
        }
        this.logger.debug("SSE API has been started.");
    }

    public void stop(BundleContext bc) throws Exception {
        context = null;
        if (this.sseFeatureRegistration != null) {
            this.sseFeatureRegistration.unregister();
            this.logger.debug("SseFeature unregistered.");
        }
        if (this.blockingAsyncFeatureRegistration != null) {
            this.blockingAsyncFeatureRegistration.unregister();
            this.logger.debug("BlockingAsyncFeature unregistered.");
        }
        this.logger.debug("SSE API has been stopped.");
    }

    public static BundleContext getContext() {
        return context;
    }
}

