/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandProvider<E>
implements ServiceTrackerCustomizer {
    protected Logger logger;
    protected BundleContext bc;
    Map<URL, List<String>> providerPortfolio = new HashMap<URL, List<String>>();
    protected ServiceTracker<Parser, Parser> parserTracker;
    protected Map<String, Parser<E>> parsers = new HashMap<String, Parser<E>>();
    protected Map<String, E> providedObjectsHolder = new HashMap<String, E>();

    public AbstractCommandProvider(BundleContext context) {
        this.bc = context;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.parserTracker = new ServiceTracker(context, Parser.class.getName(), (ServiceTrackerCustomizer)this);
        this.parserTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.parserTracker != null) {
            this.parserTracker.close();
            this.parserTracker = null;
            this.parsers = null;
            Map<Object, Object> map = this.providedObjectsHolder;
            synchronized (map) {
                this.providedObjectsHolder = null;
            }
            map = this.providerPortfolio;
            synchronized (map) {
                this.providerPortfolio = null;
            }
        }
    }

    public Object addingService(ServiceReference reference) {
        Parser service = (Parser)this.bc.getService(reference);
        String key = (String)reference.getProperty("format");
        key = key == null ? "json" : key;
        this.parsers.put(key, service);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        String key = (String)reference.getProperty("format");
        key = key == null ? "json" : key;
        this.parsers.remove(key);
    }

    public String exportData(String parserType, Set<E> set, File file) throws Exception {
        OutputStreamWriter oWriter = new OutputStreamWriter(new FileOutputStream(file));
        Parser<E> parser = this.parsers.get(parserType);
        if (parser != null) {
            try {
                parser.serialize(set, oWriter);
                return "SUCCESS";
            }
            finally {
                oWriter.close();
            }
        }
        return String.format("%s! Parser \"%s\" not found!", "FAIL", parserType);
    }

    protected abstract Set<E> importData(URL var1, Parser<E> var2, InputStreamReader var3) throws ParsingException;
}

