/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommand;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandsPluggable;

public class AutomationCommandRemove
extends AutomationCommand {
    private String id;
    private URL url;

    public AutomationCommandRemove(String command, String[] params, int providerType, AutomationCommandsPluggable autoCommands) {
        super(command, params, providerType, autoCommands);
    }

    @Override
    public String execute() {
        if (this.parsingResult != "SUCCESS") {
            return this.parsingResult;
        }
        switch (this.providerType) {
            case 3: {
                return this.autoCommands.remove(3, this.url);
            }
            case 2: {
                return this.autoCommands.remove(2, this.url);
            }
            case 1: {
                if (this.command == "removeRule") {
                    return this.autoCommands.removeRule(this.id);
                }
                if (this.command != "removeRules") break;
                return this.autoCommands.removeRules(this.id);
            }
        }
        return "FAIL";
    }

    private URL initURL(String parameterValue) {
        try {
            return new URL(parameterValue);
        }
        catch (MalformedURLException malformedURLException) {
            File f = new File(parameterValue);
            if (f.isFile()) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException2) {}
            }
            return null;
        }
    }

    @Override
    protected String parseOptionsAndParameters(String[] parameterValues) {
        boolean getUrl = true;
        boolean getId = true;
        if (this.providerType == 1) {
            getUrl = false;
        } else {
            getId = false;
        }
        int i = 0;
        while (i < parameterValues.length) {
            if (parameterValues[i] != null) {
                if (parameterValues[i].equals("-st")) {
                    this.st = true;
                } else {
                    if (parameterValues[i].charAt(0) == '-') {
                        return String.format("Unsupported option: %s", parameterValues[i]);
                    }
                    if (getUrl) {
                        this.url = this.initURL(parameterValues[i]);
                        if (this.url != null) {
                            getUrl = false;
                        }
                    } else if (getId) {
                        this.id = parameterValues[i];
                        if (this.id != null) {
                            getId = false;
                        }
                    } else {
                        return String.format("Unsupported parameter: %s", parameterValues[i]);
                    }
                }
            }
            ++i;
        }
        if (getUrl) {
            return "Missing source URL parameter!";
        }
        if (getId) {
            return "Missing UID parameter!";
        }
        return "SUCCESS";
    }
}

