/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommand;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandEnableRule;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandExport;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandImport;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandList;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandRemove;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommands;
import org.eclipse.smarthome.automation.internal.commands.CommandlineModuleTypeProvider;
import org.eclipse.smarthome.automation.internal.commands.CommandlineRuleImporter;
import org.eclipse.smarthome.automation.internal.commands.CommandlineTemplateProvider;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AutomationCommandsPluggable
extends AutomationCommands
implements ServiceTrackerCustomizer,
ConsoleCommandExtension {
    public static final String NAME = "automation";
    public static final String DESCRIPTION = "Commands for managing Automation Rules, Templates and ModuleTypes resources.";
    static RuleRegistry ruleRegistry;
    static TemplateRegistry templateRegistry;
    static ModuleTypeRegistry moduleTypeRegistry;
    private static final int MODULE_TYPE_REGISTRY = 3;
    private static final int TEMPLATE_REGISTRY = 2;
    private static final int RULE_REGISTRY = 1;
    private ServiceTracker tracker;
    private ServiceRegistration commandsServiceReg;

    public AutomationCommandsPluggable(BundleContext bc) {
        this.bc = bc;
        this.moduleTypeProvider = new CommandlineModuleTypeProvider(bc);
        this.templateProvider = new CommandlineTemplateProvider(bc);
        this.ruleImporter = new CommandlineRuleImporter(bc);
        try {
            Filter filter = bc.createFilter("(|(objectClass=" + RuleRegistry.class.getName() + ")(objectClass=" + TemplateRegistry.class.getName() + ")(objectClass=" + ModuleTypeRegistry.class.getName() + "))");
            this.tracker = new ServiceTracker(bc, filter, (ServiceTrackerCustomizer)this);
            this.tracker.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        this.commandsServiceReg = bc.registerService(ConsoleCommandExtension.class.getName(), (Object)this, null);
    }

    @Override
    public void stop() {
        this.commandsServiceReg.unregister();
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        super.stop();
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bc.getService(reference);
        if (service instanceof TemplateRegistry) {
            templateRegistry = (TemplateRegistry)service;
        }
        if (service instanceof RuleRegistry) {
            ruleRegistry = (RuleRegistry)service;
        }
        if (service instanceof ModuleTypeRegistry) {
            moduleTypeRegistry = (ModuleTypeRegistry)service;
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (service == templateRegistry) {
            templateRegistry = null;
        }
        if (service == ruleRegistry) {
            ruleRegistry = null;
        }
        if (service == moduleTypeRegistry) {
            moduleTypeRegistry = null;
        }
    }

    public void execute(String[] args, Console console) {
        String res;
        if (args.length == 0) {
            console.println(StringUtils.join(this.getUsages(), (String)"\n"));
            return;
        }
        String command = args[0];
        String[] params = new String[args.length - 1];
        if (params.length > 0) {
            System.arraycopy(args, 1, params, 0, params.length);
        }
        if ((res = super.executeCommand(command, params)) == null) {
            console.println(String.format("Unsupported command %s", command));
        } else {
            console.println(res);
        }
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("listModuleTypes [-st] <filter> <language>", "lists all Module Types. If filter is present, lists only matching Module Types. If language is missing, the default language will be used."), this.buildCommandUsage("listTemplates [-st] <filter> <language>", "lists all Templates. If filter is present, lists only matching Templates. If language is missing, the default language will be used."), this.buildCommandUsage("listRules [-st] <filter>", "lists all Rules. If filter is present, lists only matching Rules"), this.buildCommandUsage("removeModuleTypes [-st] <url>", "Removes the Module Types, loaded from the given url"), this.buildCommandUsage("removeTemplates [-st] <url>", "Removes the Templates, loaded from the given url"), this.buildCommandUsage("removeRule [-st] <uid>", "Removes the rule, specified by given UID"), this.buildCommandUsage("removeRules [-st] <filter>", "Removes the rules. If filter is present, removes only matching Rules"), this.buildCommandUsage("importModuleTypes [-p] <parserType> [-st] <url>", "Imports Module Types from given url. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("importTemplates [-p] <parserType> [-st] <url>", "Imports Templates from given url. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("importRules [-p] <parserType> [-st] <url>", "Imports Rules from given url. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("exportModuleTypes [-p] <parserType> [-st] <file>", "Exports Module Types in a file. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("exportTemplates [-p] <parserType> [-st] <file>", "Exports Templates in a file. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("exportRules [-p] <parserType> [-st] <file>", "Exports Rules in a file. If parser type missing, \"json\" parser will be set as default"), this.buildCommandUsage("enableRule [-st] <uid> <enable>", "Enables the Rule, specified by given UID. If enable parameter is missing, the result of the command will be visualization of enabled/disabled state of the rule, if its value is \"true\" or \"false\", the result of the command will be to set enable/disable on the Rule."));
    }

    public String getCommand() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Rule getRule(String uid) {
        if (ruleRegistry != null) {
            return (Rule)ruleRegistry.get((Object)uid);
        }
        return null;
    }

    @Override
    public Template getTemplate(String templateUID, Locale locale) {
        if (templateRegistry != null) {
            return templateRegistry.get(templateUID, locale);
        }
        return null;
    }

    @Override
    public Collection<Template> getTemplates(Locale locale) {
        if (templateRegistry != null) {
            return templateRegistry.getAll(locale);
        }
        return null;
    }

    @Override
    public ModuleType getModuleType(String typeUID, Locale locale) {
        if (moduleTypeRegistry != null) {
            return moduleTypeRegistry.get(typeUID, locale);
        }
        return null;
    }

    @Override
    public <T extends ModuleType> Collection<T> getModuleTypes(Class<T> clazz, Locale locale) {
        if (moduleTypeRegistry != null) {
            return moduleTypeRegistry.getAll(clazz, locale);
        }
        return null;
    }

    @Override
    public String removeRule(String uid) {
        if (ruleRegistry != null) {
            if (ruleRegistry.remove((Object)uid) != null) {
                return "SUCCESS";
            }
            return String.format("Rule with id '%s' does not exist.", uid);
        }
        return String.format("%s! RuleRegistry not available!", "FAIL");
    }

    @Override
    public String removeRules(String ruleFilter) {
        if (ruleRegistry != null) {
            for (Rule r : ruleRegistry.getAll()) {
                if (!r.getUID().contains(ruleFilter)) continue;
                ruleRegistry.remove((Object)r.getUID());
            }
            return "SUCCESS";
        }
        return String.format("%s! RuleRegistry not available!", "FAIL");
    }

    @Override
    protected AutomationCommand parseCommand(String command, String[] params) {
        if (command.equalsIgnoreCase("importModuleTypes")) {
            return new AutomationCommandImport("importModuleTypes", params, 3, this);
        }
        if (command.equalsIgnoreCase("exportModuleTypes")) {
            return new AutomationCommandExport("exportModuleTypes", params, 3, this);
        }
        if (command.equalsIgnoreCase("listModuleTypes")) {
            return new AutomationCommandList("listModuleTypes", params, 3, this);
        }
        if (command.equalsIgnoreCase("importTemplates")) {
            return new AutomationCommandImport("importTemplates", params, 2, this);
        }
        if (command.equalsIgnoreCase("exportTemplates")) {
            return new AutomationCommandExport("exportTemplates", params, 2, this);
        }
        if (command.equalsIgnoreCase("listTemplates")) {
            return new AutomationCommandList("listTemplates", params, 2, this);
        }
        if (command.equalsIgnoreCase("importRules")) {
            return new AutomationCommandImport("importRules", params, 1, this);
        }
        if (command.equalsIgnoreCase("exportRules")) {
            return new AutomationCommandExport("exportRules", params, 1, this);
        }
        if (command.equalsIgnoreCase("listRules")) {
            return new AutomationCommandList("listRules", params, 1, this);
        }
        if (command.equalsIgnoreCase("removeTemplates")) {
            return new AutomationCommandRemove("removeTemplates", params, 2, this);
        }
        if (command.equalsIgnoreCase("removeModuleTypes")) {
            return new AutomationCommandRemove("removeModuleTypes", params, 3, this);
        }
        if (command.equalsIgnoreCase("removeRule")) {
            return new AutomationCommandRemove("removeRule", params, 1, this);
        }
        if (command.equalsIgnoreCase("removeRules")) {
            return new AutomationCommandRemove("removeRules", params, 1, this);
        }
        if (command.equalsIgnoreCase("enableRule")) {
            return new AutomationCommandEnableRule("enableRule", params, 1, this);
        }
        return null;
    }

    protected String buildCommandUsage(String description) {
        return String.format("%s - %s", this.getCommand(), description);
    }

    protected String buildCommandUsage(String syntax, String description) {
        return String.format("%s %s - %s", this.getCommand(), syntax, description);
    }

    @Override
    public Collection<Rule> getRules() {
        if (ruleRegistry != null) {
            return ruleRegistry.getAll();
        }
        return null;
    }

    @Override
    public RuleStatus getRuleStatus(String ruleUID) {
        if (ruleRegistry != null) {
            RuleStatusInfo rsi = ruleRegistry.getStatus(ruleUID);
            return rsi != null ? rsi.getStatus() : null;
        }
        return null;
    }

    @Override
    public void setEnabled(String uid, boolean isEnabled) {
        if (ruleRegistry != null) {
            ruleRegistry.setEnabled(uid, isEnabled);
        }
    }
}

