/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;

public class SelectionRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Selection;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        String snippet = this.getSnippet("selection");
        snippet = StringUtils.replace((String)snippet, (String)"%category%", (String)this.escapeURLPath(this.itemUIRegistry.getCategory(w)));
        snippet = StringUtils.replace((String)snippet, (String)"%format%", (String)this.getFormat());
        snippet = StringUtils.replace((String)snippet, (String)"%label_header%", (String)this.getLabel(w));
        String state = this.itemUIRegistry.getState(w).toString();
        Selection selection = (Selection)w;
        StringBuilder rowSB = new StringBuilder();
        for (Mapping mapping : selection.getMappings()) {
            String rowSnippet = this.getSnippet("selection_row");
            String command = mapping.getCmd() != null ? mapping.getCmd() : "";
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%item%", (String)(w.getItem() != null ? w.getItem() : ""));
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%cmd%", (String)StringEscapeUtils.escapeHtml((String)command));
            rowSnippet = StringUtils.replace((String)rowSnippet, (String)"%label%", (String)(mapping.getLabel() != null ? mapping.getLabel() : ""));
            rowSnippet = state.equals(mapping.getCmd()) ? StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"checked=\"true\"") : StringUtils.replace((String)rowSnippet, (String)"%checked%", (String)"");
            rowSB.append(rowSnippet);
        }
        snippet = StringUtils.replace((String)snippet, (String)"%rows%", (String)rowSB.toString());
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }
}

