/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Setpoint;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;

public class SetpointRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Setpoint;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        BigDecimal maxValue;
        BigDecimal minValue;
        Setpoint sp = (Setpoint)w;
        State state = this.itemUIRegistry.getState(w);
        String newLowerState = state.toString();
        String newHigherState = state.toString();
        BigDecimal step = sp.getStep();
        if (step == null) {
            step = BigDecimal.ONE;
        }
        if ((minValue = sp.getMinValue()) == null) {
            minValue = BigDecimal.ZERO;
        }
        if ((maxValue = sp.getMaxValue()) == null) {
            maxValue = BigDecimal.valueOf(100L);
        }
        if (state instanceof DecimalType) {
            DecimalType actState = (DecimalType)state;
            BigDecimal newLower = actState.toBigDecimal().subtract(step);
            BigDecimal newHigher = actState.toBigDecimal().add(step);
            if (newLower.compareTo(minValue) < 0) {
                newLower = minValue;
            }
            if (newHigher.compareTo(maxValue) > 0) {
                newHigher = maxValue;
            }
            newLowerState = newLower.toString();
            newHigherState = newHigher.toString();
        }
        String snippetName = "setpoint";
        String snippet = this.getSnippet(snippetName);
        snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)this.itemUIRegistry.getWidgetId(w));
        snippet = StringUtils.replace((String)snippet, (String)"%category%", (String)this.escapeURLPath(this.itemUIRegistry.getCategory(w)));
        snippet = StringUtils.replace((String)snippet, (String)"%item%", (String)w.getItem());
        snippet = StringUtils.replace((String)snippet, (String)"%state%", (String)state.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%newlowerstate%", (String)newLowerState);
        snippet = StringUtils.replace((String)snippet, (String)"%newhigherstate%", (String)newHigherState);
        snippet = StringUtils.replace((String)snippet, (String)"%label%", (String)this.getLabel(w));
        snippet = StringUtils.replace((String)snippet, (String)"%format%", (String)this.getFormat());
        snippet = StringUtils.replace((String)snippet, (String)"%servletname%", (String)"app");
        snippet = StringUtils.replace((String)snippet, (String)"%minValue%", (String)minValue.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%maxValue%", (String)maxValue.toString());
        snippet = StringUtils.replace((String)snippet, (String)"%step%", (String)step.toString());
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }
}

