/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Switch;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.classic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.classic.render.RenderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(SwitchRenderer.class);

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Switch;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Switch s = (Switch)w;
        String snippetName = null;
        Item item = null;
        try {
            item = this.itemUIRegistry.getItem(w.getItem());
            snippetName = s.getMappings().size() == 0 ? (item instanceof RollershutterItem ? "rollerblind" : (item instanceof GroupItem && ((GroupItem)item).getBaseItem() instanceof RollershutterItem ? "rollerblind" : "switch")) : "buttons";
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Cannot determine item type of '{}'", (Object)w.getItem(), (Object)e);
            snippetName = "switch";
        }
        String snippet = this.getSnippet(snippetName);
        snippet = StringUtils.replace((String)snippet, (String)"%id%", (String)this.itemUIRegistry.getWidgetId(w));
        snippet = StringUtils.replace((String)snippet, (String)"%category%", (String)this.getCategory(w));
        snippet = StringUtils.replace((String)snippet, (String)"%state%", (String)this.getState(w));
        snippet = StringUtils.replace((String)snippet, (String)"%format%", (String)this.getFormat());
        snippet = StringUtils.replace((String)snippet, (String)"%item%", (String)w.getItem());
        snippet = StringUtils.replace((String)snippet, (String)"%label%", (String)this.getLabel(w));
        snippet = StringUtils.replace((String)snippet, (String)"%servletname%", (String)"app");
        State state = this.itemUIRegistry.getState(w);
        if (s.getMappings().size() == 0) {
            if (state instanceof PercentType) {
                OnOffType onOffType = state = ((PercentType)state).intValue() > 0 ? OnOffType.ON : OnOffType.OFF;
            }
            snippet = state.equals(OnOffType.ON) ? snippet.replaceAll("%checked%", "checked=true") : snippet.replaceAll("%checked%", "");
        } else {
            StringBuilder buttons = new StringBuilder();
            for (Mapping mapping : s.getMappings()) {
                String button = this.getSnippet("button");
                button = StringUtils.replace((String)button, (String)"%item%", (String)w.getItem());
                button = StringUtils.replace((String)button, (String)"%cmd%", (String)mapping.getCmd());
                button = StringUtils.replace((String)button, (String)"%label%", (String)mapping.getLabel());
                button = s.getMappings().size() > 1 && state.toString().equals(mapping.getCmd()) ? StringUtils.replace((String)button, (String)"%type%", (String)"Warn") : StringUtils.replace((String)button, (String)"%type%", (String)"Action");
                buttons.append(button);
            }
            snippet = StringUtils.replace((String)snippet, (String)"%buttons%", (String)buttons.toString());
        }
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }
}

