/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.classic.internal.servlet;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.ui.classic.internal.servlet.BaseServlet;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdServlet
extends BaseServlet {
    private final Logger logger = LoggerFactory.getLogger(CmdServlet.class);
    public static final String SERVLET_NAME = "CMD";
    private EventPublisher eventPublisher;

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void activate() {
        try {
            this.logger.debug("Starting up CMD servlet at /classicui/CMD");
            Hashtable props = new Hashtable();
            this.httpService.registerServlet("/classicui/CMD", (Servlet)this, props, this.createHttpContext());
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
    }

    protected void deactivate() {
        this.httpService.unregister("/classicui/CMD");
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        res.setContentType("text/plain");
        for (Object key : req.getParameterMap().keySet()) {
            String itemName = key.toString();
            if (itemName.startsWith("__")) continue;
            String commandName = req.getParameter(itemName);
            try {
                Command command;
                Item item = this.itemRegistry.getItem(itemName);
                if ((item instanceof SwitchItem || item instanceof GroupItem) && commandName.equals("TOGGLE")) {
                    String string = commandName = OnOffType.ON.equals((Object)item.getStateAs(OnOffType.class)) ? "OFF" : "ON";
                }
                if ((command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandName)) != null) {
                    this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command));
                    continue;
                }
                this.logger.warn("Received unknown command '{}' for item '{}'", (Object)commandName, (Object)itemName);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                this.logger.warn("Received command '{}' for item '{}', but the item does not exist in the registry", (Object)commandName, (Object)itemName);
            }
        }
    }
}

