/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.internal;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.smarthome.io.transport.mdns.MDNSService;
import org.eclipse.smarthome.io.transport.mdns.ServiceDescription;
import org.osgi.framework.BundleContext;

public class MDNSAnnouncer {
    private int httpSSLPort;
    private int httpPort;
    private String mdnsName;
    private MDNSService mdnsService;

    public void setMDNSService(MDNSService mdnsService) {
        this.mdnsService = mdnsService;
    }

    public void unsetMDNSService(MDNSService mdnsService) {
        this.mdnsService = null;
    }

    public void activate(BundleContext bundleContext, Map<String, Object> properties) {
        if (!"false".equalsIgnoreCase((String)properties.get("enabled")) && this.mdnsService != null) {
            this.mdnsName = bundleContext.getProperty("mdnsName");
            if (this.mdnsName == null) {
                this.mdnsName = "smarthome";
            }
            try {
                this.httpPort = Integer.parseInt(bundleContext.getProperty("org.osgi.service.http.port"));
                this.mdnsService.registerService(this.getDefaultServiceDescription());
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                this.httpSSLPort = Integer.parseInt(bundleContext.getProperty("org.osgi.service.http.port.secure"));
                this.mdnsService.registerService(this.getSSLServiceDescription());
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void deactivate() {
        if (this.mdnsService != null) {
            this.mdnsService.unregisterService(this.getDefaultServiceDescription());
            this.mdnsService.unregisterService(this.getSSLServiceDescription());
        }
    }

    private ServiceDescription getDefaultServiceDescription() {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("uri", "/rest");
        return new ServiceDescription("_" + this.mdnsName + "-server._tcp.local.", this.mdnsName, this.httpPort, serviceProperties);
    }

    private ServiceDescription getSSLServiceDescription() {
        ServiceDescription description = this.getDefaultServiceDescription();
        description.serviceType = "_" + this.mdnsName + "-server-ssl._tcp.local.";
        description.serviceName = this.mdnsName + "-ssl";
        description.servicePort = this.httpSSLPort;
        return description;
    }
}

