/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mdns.internal;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import javax.jmdns.ServiceInfo;
import org.eclipse.smarthome.io.transport.mdns.MDNSClient;
import org.eclipse.smarthome.io.transport.mdns.MDNSService;
import org.eclipse.smarthome.io.transport.mdns.ServiceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNSServiceImpl
implements MDNSService {
    private final Logger logger = LoggerFactory.getLogger(MDNSServiceImpl.class);
    private MDNSClient mdnsClient;
    private Set<ServiceInfo> servicesToRegisterQueue = new CopyOnWriteArraySet<ServiceInfo>();

    public void setMDNSClient(MDNSClient client) {
        this.mdnsClient = client;
        if (this.servicesToRegisterQueue.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (ServiceInfo serviceInfo : MDNSServiceImpl.this.servicesToRegisterQueue) {
                        try {
                            MDNSServiceImpl.this.logger.debug("Registering new service " + serviceInfo.getType() + " at port " + String.valueOf(serviceInfo.getPort()));
                            MDNSServiceImpl.this.mdnsClient.getClient().registerService(serviceInfo);
                        }
                        catch (IOException e) {
                            MDNSServiceImpl.this.logger.error(e.getMessage());
                        }
                    }
                    MDNSServiceImpl.this.servicesToRegisterQueue.clear();
                }
            };
            Executors.newSingleThreadExecutor().execute(runnable);
        }
    }

    public void unsetMDNSClient(MDNSClient mdnsClient) {
        this.mdnsClient = null;
    }

    @Override
    public void registerService(final ServiceDescription description) {
        if (this.mdnsClient == null) {
            ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
            this.servicesToRegisterQueue.add(serviceInfo);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
                    try {
                        MDNSServiceImpl.this.logger.debug("Registering new service " + description.serviceType + " at port " + String.valueOf(description.servicePort));
                        MDNSServiceImpl.this.mdnsClient.getClient().registerService(serviceInfo);
                    }
                    catch (IOException e) {
                        MDNSServiceImpl.this.logger.error(e.getMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                        MDNSServiceImpl.this.logger.debug("Not registering service, because service is already deactivated!");
                    }
                }
            };
            Executors.newSingleThreadExecutor().execute(runnable);
        }
    }

    @Override
    public void unregisterService(ServiceDescription description) {
        if (this.mdnsClient == null) {
            return;
        }
        ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
        this.logger.debug("Unregistering service " + description.serviceType + " at port " + String.valueOf(description.servicePort));
        this.mdnsClient.getClient().unregisterService(serviceInfo);
    }

    protected void unregisterAllServices() {
        if (this.mdnsClient != null) {
            this.mdnsClient.getClient().unregisterAllServices();
        }
    }

    public void activate() {
    }

    public void deactivate() {
        this.unregisterAllServices();
        try {
            if (this.mdnsClient != null) {
                this.mdnsClient.getClient().close();
                this.logger.debug("mDNS service has been stopped");
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }
}

