/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.mapdb;

import java.io.File;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.eclipse.smarthome.storage.mapdb.MapDbStorage;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDbStorageService
implements StorageService {
    private final Logger logger = LoggerFactory.getLogger(MapDbStorageService.class);
    private static final String DB_FILE_NAME = "storage.mapdb";
    private DB db;
    private String dbFolderName = "mapdb";

    public void activate() {
        this.dbFolderName = String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + this.dbFolderName;
        File folder = new File(this.dbFolderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File dbFile = new File(this.dbFolderName, DB_FILE_NAME);
        this.db = DBMaker.newFileDB((File)dbFile).closeOnJvmShutdown().make();
        this.logger.debug("Opened MapDB file at '{}'.", (Object)dbFile.getAbsolutePath());
    }

    public void deactivate() {
        this.db.close();
        this.logger.debug("Deactivated MapDB Storage Service.");
    }

    public <T> Storage<T> getStorage(String name, ClassLoader classLoader) {
        return new MapDbStorage(this.db, name, classLoader);
    }

    public <T> Storage<T> getStorage(String name) {
        return this.getStorage(name, null);
    }
}

