/**
 * Copyright (c) 2015 openHAB UG (haftungsbeschraenkt) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.smarthome.model.formatting;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.smarthome.model.services.ItemsGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * This class contains custom formatting description.
 */
@SuppressWarnings("all")
public class ItemsFormatter extends AbstractDeclarativeFormatter {
  @Inject
  @Extension
  private ItemsGrammarAccess _itemsGrammarAccess;
  
  @Override
  protected void configureFormatting(final FormattingConfig c) {
    FormattingConfig.LinewrapLocator _setLinewrap = c.setLinewrap(1, 1, 2);
    ParserRule _modelGroupItemRule = this._itemsGrammarAccess.getModelGroupItemRule();
    _setLinewrap.before(_modelGroupItemRule);
    FormattingConfig.LinewrapLocator _setLinewrap_1 = c.setLinewrap(1, 1, 2);
    ParserRule _modelItemTypeRule = this._itemsGrammarAccess.getModelItemTypeRule();
    _setLinewrap_1.before(_modelItemTypeRule);
    FormattingConfig.NoSpaceLocator _setNoSpace = c.setNoSpace();
    this.withinKeywordPairs(_setNoSpace, "<", ">");
    FormattingConfig.NoSpaceLocator _setNoSpace_1 = c.setNoSpace();
    this.withinKeywordPairs(_setNoSpace_1, "(", ")");
    FormattingConfig.IndentationLocatorStart _setIndentationIncrement = c.setIndentationIncrement();
    ParserRule _modelItemTypeRule_1 = this._itemsGrammarAccess.getModelItemTypeRule();
    _setIndentationIncrement.after(_modelItemTypeRule_1);
    FormattingConfig.IndentationLocatorEnd _setIndentationDecrement = c.setIndentationDecrement();
    ParserRule _modelItemTypeRule_2 = this._itemsGrammarAccess.getModelItemTypeRule();
    _setIndentationDecrement.before(_modelItemTypeRule_2);
    FormattingConfig.IndentationLocatorStart _setIndentationIncrement_1 = c.setIndentationIncrement();
    ParserRule _modelGroupItemRule_1 = this._itemsGrammarAccess.getModelGroupItemRule();
    _setIndentationIncrement_1.after(_modelGroupItemRule_1);
    FormattingConfig.IndentationLocatorEnd _setIndentationDecrement_1 = c.setIndentationDecrement();
    ParserRule _modelGroupItemRule_2 = this._itemsGrammarAccess.getModelGroupItemRule();
    _setIndentationDecrement_1.before(_modelGroupItemRule_2);
    c.setAutoLinewrap(160);
    FormattingConfig.LinewrapLocator _setLinewrap_2 = c.setLinewrap(0, 1, 2);
    TerminalRule _sL_COMMENTRule = this._itemsGrammarAccess.getSL_COMMENTRule();
    _setLinewrap_2.before(_sL_COMMENTRule);
    FormattingConfig.LinewrapLocator _setLinewrap_3 = c.setLinewrap(0, 1, 2);
    TerminalRule _mL_COMMENTRule = this._itemsGrammarAccess.getML_COMMENTRule();
    _setLinewrap_3.before(_mL_COMMENTRule);
    FormattingConfig.LinewrapLocator _setLinewrap_4 = c.setLinewrap(0, 1, 1);
    TerminalRule _mL_COMMENTRule_1 = this._itemsGrammarAccess.getML_COMMENTRule();
    _setLinewrap_4.after(_mL_COMMENTRule_1);
  }
  
  public void withinKeywordPairs(final FormattingConfig.NoSpaceLocator locator, final String leftKW, final String rightKW) {
    List<Pair<Keyword, Keyword>> _findKeywordPairs = this._itemsGrammarAccess.findKeywordPairs(leftKW, rightKW);
    for (final Pair<Keyword, Keyword> pair : _findKeywordPairs) {
      {
        Keyword _first = pair.getFirst();
        locator.after(_first);
        Keyword _second = pair.getSecond();
        locator.before(_second);
      }
    }
  }
}
