package org.eclipse.smarthome.model.validation;

import org.eclipse.smarthome.model.items.ItemsPackage;
import org.eclipse.smarthome.model.items.ModelItem;
import org.eclipse.smarthome.model.validation.AbstractItemsValidator;
import org.eclipse.xtext.validation.Check;

/**
 * Custom validation rules.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#validation
 */
@SuppressWarnings("all")
public class ItemsValidator extends AbstractItemsValidator {
  @Check
  public void checkItemName(final ModelItem item) {
    boolean _or = false;
    if ((item == null)) {
      _or = true;
    } else {
      String _name = item.getName();
      boolean _tripleEquals = (_name == null);
      _or = _tripleEquals;
    }
    if (_or) {
      return;
    }
    String _name_1 = item.getName();
    boolean _contains = _name_1.contains("-");
    if (_contains) {
      this.error("Item name must not contain dashes.", ItemsPackage.Literals.MODEL_ITEM__NAME);
    }
  }
}
