/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.handler;

import java.util.Map;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.core.events.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEventConditionHandler
extends BaseModuleHandler<Condition>
implements ConditionHandler {
    public final Logger logger = LoggerFactory.getLogger(GenericEventConditionHandler.class);
    public static final String MODULETYPE_ID = "core.GenericEventCondition";
    private static final String TOPIC = "topic";
    private static final String EVENTTYPE = "eventType";
    private static final String SOURCE = "source";
    private static final String PAYLOAD = "payload";

    public GenericEventConditionHandler(Condition module) {
        super((Module)module);
    }

    private boolean isConfiguredAndMatches(String keyParam, String value) {
        String configValue;
        Object mo = ((Condition)this.module).getConfiguration().get(keyParam);
        String string = configValue = mo != null && mo instanceof String ? (String)mo : null;
        if (configValue != null) {
            if (keyParam.equals(PAYLOAD)) {
                configValue = configValue.startsWith("*") ? configValue : ".*" + configValue;
                String string2 = configValue = configValue.endsWith("*") ? configValue : String.valueOf(configValue) + ".*";
            }
            if (value != null) {
                return value.matches(configValue);
            }
            return false;
        }
        return true;
    }

    public boolean isSatisfied(Map<String, Object> inputs) {
        Event event;
        Event event2 = event = inputs.get("event") != null ? (Event)inputs.get("event") : null;
        if (event != null) {
            return this.isConfiguredAndMatches(TOPIC, event.getTopic()) && this.isConfiguredAndMatches(SOURCE, event.getSource()) && this.isConfiguredAndMatches(PAYLOAD, event.getPayload()) && this.isConfiguredAndMatches(EVENTTYPE, event.getType());
        }
        return false;
    }
}

