/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.handler;

import com.google.gson.JsonElement;
import org.eclipse.smarthome.binding.tradfri.TradfriBindingConstants;
import org.eclipse.smarthome.binding.tradfri.handler.TradfriThingHandler;
import org.eclipse.smarthome.binding.tradfri.internal.model.TradfriLightData;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriLightHandler
extends TradfriThingHandler {
    private final Logger logger = LoggerFactory.getLogger(TradfriLightHandler.class);
    private static final int STEP = 10;
    private TradfriLightData state;

    public TradfriLightHandler(Thing thing) {
        super(thing);
    }

    @Override
    public void onUpdate(JsonElement data) {
        if (this.active && !data.isJsonNull()) {
            PercentType colorTemp;
            this.state = new TradfriLightData(data);
            this.updateStatus(this.state.getReachabilityStatus() ? ThingStatus.ONLINE : ThingStatus.OFFLINE);
            if (!this.state.getOnOffState()) {
                this.logger.debug("Setting state to OFF");
                this.updateState("brightness", (State)PercentType.ZERO);
                if (this.lightHasColorSupport()) {
                    this.updateState("color", (State)HSBType.BLACK);
                }
                return;
            }
            PercentType dimmer = this.state.getBrightness();
            if (dimmer != null && !this.lightHasColorSupport()) {
                this.updateState("brightness", (State)dimmer);
            }
            if ((colorTemp = this.state.getColorTemperature()) != null) {
                this.updateState("color_temperature", (State)colorTemp);
            }
            HSBType color = null;
            if (this.lightHasColorSupport() && (color = this.state.getColor()) != null) {
                this.updateState("color", (State)color);
            }
            this.updateDeviceProperties(this.state);
            this.logger.debug("Updating thing for lightId {} to state {dimmer: {}, colorTemp: {}, color: {}, firmwareVersion: {}, modelId: {}, vendor: {}}", new Object[]{this.state.getDeviceId(), dimmer, colorTemp, color, this.state.getFirmwareVersion(), this.state.getModelId(), this.state.getVendor()});
        }
    }

    private void setBrightness(PercentType percent) {
        TradfriLightData data = new TradfriLightData();
        data.setBrightness(percent).setTransitionTime(5);
        this.set(data.getJsonString());
    }

    private void setState(OnOffType onOff) {
        TradfriLightData data = new TradfriLightData();
        data.setOnOffState(onOff == OnOffType.ON);
        this.set(data.getJsonString());
    }

    private void setColorTemperature(PercentType percent) {
        TradfriLightData data = new TradfriLightData();
        data.setColorTemperature(percent).setTransitionTime(5);
        this.set(data.getJsonString());
    }

    private void setColor(HSBType hsb) {
        TradfriLightData data = new TradfriLightData();
        data.setColor(hsb).setTransitionTime(5);
        this.set(data.getJsonString(), 1000);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        block14: {
            if (!this.active) break block14;
            if (command instanceof RefreshType) {
                this.logger.debug("Refreshing channel {}", (Object)channelUID);
                this.coapClient.asyncGet(this);
                return;
            }
            switch (channelUID.getId()) {
                case "brightness": {
                    this.handleBrightnessCommand(command);
                    break;
                }
                case "color_temperature": {
                    this.handleColorTemperatureCommand(command);
                    break;
                }
                case "color": {
                    this.handleColorCommand(command);
                    break;
                }
                default: {
                    this.logger.error("Unknown channel UID {}", (Object)channelUID);
                }
            }
        }
    }

    private void handleBrightnessCommand(Command command) {
        if (command instanceof PercentType) {
            this.setBrightness((PercentType)command);
        } else if (command instanceof OnOffType) {
            this.setState((OnOffType)command);
        } else if (command instanceof IncreaseDecreaseType) {
            if (this.state != null && this.state.getBrightness() != null) {
                int current = this.state.getBrightness().intValue();
                if (IncreaseDecreaseType.INCREASE.equals((Object)command)) {
                    this.setBrightness(new PercentType(Math.min(current + 10, PercentType.HUNDRED.intValue())));
                } else {
                    this.setBrightness(new PercentType(Math.max(current - 10, PercentType.ZERO.intValue())));
                }
            } else {
                this.logger.debug("Cannot handle inc/dec as current state is not known.");
            }
        } else {
            this.logger.debug("Cannot handle command {} for channel {}", (Object)command, (Object)"brightness");
        }
    }

    private void handleColorTemperatureCommand(Command command) {
        if (command instanceof PercentType) {
            this.setColorTemperature((PercentType)command);
        } else if (command instanceof IncreaseDecreaseType) {
            if (this.state != null && this.state.getColorTemperature() != null) {
                int current = this.state.getColorTemperature().intValue();
                if (IncreaseDecreaseType.INCREASE.equals((Object)command)) {
                    this.setColorTemperature(new PercentType(Math.min(current + 10, PercentType.HUNDRED.intValue())));
                } else {
                    this.setColorTemperature(new PercentType(Math.max(current - 10, PercentType.ZERO.intValue())));
                }
            } else {
                this.logger.debug("Cannot handle inc/dec as current state is not known.");
            }
        } else {
            this.logger.debug("Can't handle command {} on channel {}", (Object)command, (Object)"color_temperature");
        }
    }

    private void handleColorCommand(Command command) {
        if (command instanceof HSBType) {
            this.setColor((HSBType)command);
            this.setBrightness(((HSBType)command).getBrightness());
        } else if (command instanceof OnOffType) {
            this.setState((OnOffType)command);
        } else if (command instanceof PercentType) {
            this.setBrightness((PercentType)command);
        } else if (command instanceof IncreaseDecreaseType) {
            if (this.state != null && this.state.getBrightness() != null) {
                int current = this.state.getBrightness().intValue();
                if (IncreaseDecreaseType.INCREASE.equals((Object)command)) {
                    this.setBrightness(new PercentType(Math.min(current + 10, PercentType.HUNDRED.intValue())));
                } else {
                    this.setBrightness(new PercentType(Math.max(current - 10, PercentType.ZERO.intValue())));
                }
            } else {
                this.logger.debug("Cannot handle inc/dec for color as current brightness is not known.");
            }
        } else {
            this.logger.debug("Can't handle command {} on channel {}", (Object)command, (Object)"color");
        }
    }

    private boolean lightHasColorSupport() {
        return this.thing.getThingTypeUID().getId().equals(TradfriBindingConstants.THING_TYPE_COLOR_LIGHT.getId());
    }
}

