/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal;

import java.net.URI;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.smarthome.binding.tradfri.internal.CoapCallback;
import org.eclipse.smarthome.binding.tradfri.internal.TradfriCoapHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriCoapClient
extends CoapClient {
    private static final int TIMEOUT = 2000;
    private static final int DEFAULT_DELAY_MILLIS = 600;
    private final Logger logger;
    private final LinkedList<PayloadCallbackPair> commandsQueue;
    private final Runnable commandExecutor;
    private Future<?> job;

    public TradfriCoapClient(URI uri) {
        super(uri);
        this.setTimeout(2000L);
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.commandsQueue = new LinkedList();
        this.commandExecutor = () -> {
            while (true) {
                try {
                    while (true) {
                        int delayTime = 0;
                        LinkedList<PayloadCallbackPair> linkedList = this.commandsQueue;
                        synchronized (linkedList) {
                            PayloadCallbackPair payloadCallbackPair = this.commandsQueue.poll();
                            if (payloadCallbackPair == null) {
                                return;
                            }
                            this.logger.debug("Proccessing payload: {}", (Object)payloadCallbackPair.payload);
                            this.put(new TradfriCoapHandler(payloadCallbackPair.callback), payloadCallbackPair.payload, 0);
                            delayTime = Optional.ofNullable(payloadCallbackPair.delay).orElse(600);
                        }
                        Thread.sleep(delayTime);
                    }
                }
                catch (InterruptedException e) {
                    this.logger.debug("commandExecutorThread was interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        };
        this.job = null;
    }

    public void startObserve(CoapCallback callback) {
        this.observe(new TradfriCoapHandler(callback));
    }

    public CompletableFuture<String> asyncGet() {
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.get(new TradfriCoapHandler(future));
        return future;
    }

    public void asyncGet(CoapCallback callback) {
        this.get(new TradfriCoapHandler(callback));
    }

    public void asyncPut(String payload, CoapCallback callback, Integer delay, ScheduledExecutorService scheduler) {
        this.asyncPut(new PayloadCallbackPair(payload, callback, delay), scheduler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncPut(PayloadCallbackPair payloadCallbackPair, ScheduledExecutorService scheduler) {
        LinkedList<PayloadCallbackPair> linkedList = this.commandsQueue;
        synchronized (linkedList) {
            if (this.commandsQueue.isEmpty()) {
                this.commandsQueue.offer(payloadCallbackPair);
                if (this.job == null || this.job.isDone()) {
                    this.job = scheduler.submit(this.commandExecutor);
                }
            } else {
                this.commandsQueue.offer(payloadCallbackPair);
            }
        }
    }

    public void shutdown() {
        if (this.job != null) {
            this.job.cancel(true);
        }
        super.shutdown();
    }

    public final class PayloadCallbackPair {
        public final String payload;
        public final CoapCallback callback;
        public final Integer delay;

        public PayloadCallbackPair(String payload, CoapCallback callback, Integer delay) {
            this.payload = payload;
            this.callback = callback;
            this.delay = delay;
        }
    }
}

