/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.tradfri.internal.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jmdns.ServiceInfo;
import org.eclipse.smarthome.binding.tradfri.TradfriBindingConstants;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.mdns.MDNSDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradfriDiscoveryParticipant
implements MDNSDiscoveryParticipant {
    private final Logger logger = LoggerFactory.getLogger(TradfriDiscoveryParticipant.class);
    private static final String SERVICE_TYPE = "_coap._udp.local.";
    private final Pattern GATEWAY_NAME_REGEX_PATTERN = Pattern.compile("(gw[:-]{1}([a-f0-9]{2}[-]?){6}){1}");

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return Collections.singleton(TradfriBindingConstants.GATEWAY_TYPE_UID);
    }

    public String getServiceType() {
        return SERVICE_TYPE;
    }

    public ThingUID getThingUID(ServiceInfo service) {
        Matcher m;
        if (service != null && (m = this.GATEWAY_NAME_REGEX_PATTERN.matcher(service.getName())).find()) {
            return new ThingUID(TradfriBindingConstants.GATEWAY_TYPE_UID, m.group(1).replaceAll("[^A-Za-z0-9_]", ""));
        }
        return null;
    }

    public DiscoveryResult createResult(ServiceInfo service) {
        ThingUID thingUID = this.getThingUID(service);
        if (thingUID != null) {
            if (service.getHostAddresses() != null && service.getHostAddresses().length > 0 && !service.getHostAddresses()[0].isEmpty()) {
                this.logger.debug("Discovered Tradfri gateway: {}", (Object)service);
                HashMap<String, Object> properties = new HashMap<String, Object>(4);
                properties.put("vendor", "IKEA of Sweden");
                properties.put("host", service.getHostAddresses()[0]);
                properties.put("port", service.getPort());
                properties.put("serialNumber", service.getName());
                String fwVersion = service.getPropertyString("version");
                if (fwVersion != null) {
                    properties.put("firmwareVersion", fwVersion);
                }
                return DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withLabel("TR\u00c5DFRI Gateway").withRepresentationProperty("host").build();
            }
            this.logger.warn("Discovered Tradfri gateway doesn't have an IP address: {}", (Object)service);
        }
        return null;
    }
}

