/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.automation.internal.core.provider.AutomationResourceBundlesEventQueue;
import org.eclipse.smarthome.automation.internal.core.provider.Vendor;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.core.i18n.ConfigDescriptionI18nUtil;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceBundleProvider<E> {
    protected static String PATH = "ESH-INF/automation";
    protected TranslationProvider i18nProvider;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BundleContext bc;
    protected String path;
    protected Map<String, Parser<E>> parsers;
    protected Map<String, E> providedObjectsHolder = new ConcurrentHashMap<String, E>();
    protected Map<Vendor, List<String>> providerPortfolio = new ConcurrentHashMap<Vendor, List<String>>();
    protected Map<Bundle, List<URL>> waitingProviders;
    protected AutomationResourceBundlesEventQueue queue = new AutomationResourceBundlesEventQueue(this);
    protected List<ProviderChangeListener<E>> listeners;

    public AbstractResourceBundleProvider() {
        this.parsers = new ConcurrentHashMap<String, Parser<E>>();
        this.waitingProviders = new ConcurrentHashMap<Bundle, List<URL>>();
    }

    protected void activate(BundleContext bc) {
        this.bc = bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        this.bc = null;
        if (this.queue != null) {
            this.queue.stop();
        }
        Object object = this.parsers;
        synchronized (object) {
            this.parsers.clear();
        }
        object = this.providedObjectsHolder;
        synchronized (object) {
            this.providedObjectsHolder.clear();
        }
        object = this.providerPortfolio;
        synchronized (object) {
            this.providerPortfolio.clear();
        }
        object = this.waitingProviders;
        synchronized (object) {
            this.waitingProviders.clear();
        }
        if (this.listeners != null) {
            object = this.listeners;
            synchronized (object) {
                this.listeners.clear();
            }
        }
    }

    protected AutomationResourceBundlesEventQueue getQueue() {
        return this.queue;
    }

    protected void addParser(Parser<E> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.put(parserType, parser);
        for (Bundle bundle : this.waitingProviders.keySet()) {
            if (bundle.getState() == 1) continue;
            this.processAutomationProvider(bundle);
        }
    }

    protected void removeParser(Parser<E> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.remove(parserType);
    }

    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void removeTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    protected void processAutomationProvider(Bundle bundle) {
        Enumeration urlEnum = null;
        try {
            if (bundle.getState() != 1) {
                urlEnum = bundle.findEntries(this.path, null, true);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug("Can't read from resource of bundle with ID {}. The bundle is uninstalled.", (Object)bundle.getBundleId(), (Object)e);
            this.processAutomationProviderUninstalled(bundle);
        }
        Vendor vendor = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
        List<String> previousPortfolio = this.getPreviousPortfolio(vendor);
        LinkedList<String> newPortfolio = new LinkedList<String>();
        if (urlEnum != null) {
            while (urlEnum.hasMoreElements()) {
                Set<E> parsedObjects;
                URL url = (URL)urlEnum.nextElement();
                if (url.getPath().endsWith(File.separator)) continue;
                String parserType = this.getParserType(url);
                Parser<E> parser = this.parsers.get(parserType);
                this.updateWaitingProviders(parser, bundle, url);
                if (parser == null || (parsedObjects = this.parseData(parser, url, bundle)) == null || parsedObjects.isEmpty()) continue;
                this.addNewProvidedObjects(newPortfolio, previousPortfolio, parsedObjects);
            }
            this.putNewPortfolio(vendor, newPortfolio);
        }
        this.removeUninstalledObjects(previousPortfolio, newPortfolio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUninstalledObjects(List<String> previousPortfolio, List<String> newPortfolio) {
        if (previousPortfolio != null && !previousPortfolio.isEmpty()) {
            for (String uid : previousPortfolio) {
                if (newPortfolio.contains(uid)) continue;
                E removedObject = this.providedObjectsHolder.remove(uid);
                if (this.listeners == null) continue;
                LinkedList<ProviderChangeListener<E>> snapshot = null;
                List<ProviderChangeListener<E>> list = this.listeners;
                synchronized (list) {
                    snapshot = new LinkedList<ProviderChangeListener<E>>(this.listeners);
                }
                for (ProviderChangeListener providerChangeListener : snapshot) {
                    providerChangeListener.removed((Provider)this, removedObject);
                }
            }
        }
    }

    protected List<String> getPreviousPortfolio(Vendor vendor) {
        List<String> portfolio = this.providerPortfolio.remove(vendor);
        if (portfolio == null) {
            for (Vendor v : this.providerPortfolio.keySet()) {
                if (!v.getVendorSymbolicName().equals(vendor.getVendorSymbolicName())) continue;
                return this.providerPortfolio.remove(v);
            }
        }
        return portfolio;
    }

    protected void putNewPortfolio(Vendor vendor, List<String> portfolio) {
        this.providerPortfolio.put(vendor, portfolio);
    }

    protected String getParserType(URL url) {
        String fileName = url.getPath();
        int fileExtesionStartIndex = fileName.lastIndexOf(".") + 1;
        if (fileExtesionStartIndex == -1) {
            return "json";
        }
        String fileExtesion = fileName.substring(fileExtesionStartIndex);
        if (fileExtesion.equals("txt")) {
            return "json";
        }
        return fileExtesion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAutomationProviderUninstalled(Bundle bundle) {
        this.waitingProviders.remove(bundle);
        Vendor vendor = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
        List<String> portfolio = this.providerPortfolio.remove(vendor);
        if (portfolio != null && !portfolio.isEmpty()) {
            for (String uid : portfolio) {
                E removedObject = this.providedObjectsHolder.remove(uid);
                if (this.listeners == null) continue;
                LinkedList<ProviderChangeListener<E>> snapshot = null;
                List<ProviderChangeListener<E>> list = this.listeners;
                synchronized (list) {
                    snapshot = new LinkedList<ProviderChangeListener<E>>(this.listeners);
                }
                for (ProviderChangeListener providerChangeListener : snapshot) {
                    providerChangeListener.removed((Provider)this, removedObject);
                }
            }
        }
    }

    protected Bundle getBundle(String uid) {
        String symbolicName = null;
        for (Map.Entry<Vendor, List<String>> entry : this.providerPortfolio.entrySet()) {
            if (!entry.getValue().contains(uid)) continue;
            symbolicName = entry.getKey().getVendorSymbolicName();
            break;
        }
        if (symbolicName != null) {
            Bundle[] bundles = this.bc.getBundles();
            int i = 0;
            while (i < bundles.length) {
                if (bundles[i].getSymbolicName().equals(symbolicName)) {
                    return bundles[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected List<ConfigDescriptionParameter> getLocalizedConfigurationDescription(TranslationProvider i18nProvider, List<ConfigDescriptionParameter> config, Bundle bundle, String uid, String prefix, Locale locale) {
        ArrayList<ConfigDescriptionParameter> configDescriptions = new ArrayList<ConfigDescriptionParameter>();
        if (config != null) {
            ConfigDescriptionI18nUtil util = new ConfigDescriptionI18nUtil(i18nProvider);
            for (ConfigDescriptionParameter parameter : config) {
                String lunitLabel;
                List loptions;
                String lpattern;
                String ldescription;
                String parameterName = parameter.getName();
                URI uri = null;
                try {
                    uri = new URI(String.valueOf(prefix) + ":" + uid + ".name");
                }
                catch (URISyntaxException e) {
                    this.logger.error("Constructed invalid uri '{}:{}.name'", new Object[]{prefix, uid, e});
                }
                String llabel = parameter.getLabel();
                if (llabel != null) {
                    llabel = util.getParameterLabel(bundle, uri, parameterName, llabel, locale);
                }
                if ((ldescription = parameter.getDescription()) != null) {
                    ldescription = util.getParameterDescription(bundle, uri, parameterName, ldescription, locale);
                }
                if ((lpattern = parameter.getPattern()) != null) {
                    lpattern = util.getParameterPattern(bundle, uri, parameterName, lpattern, locale);
                }
                if ((loptions = parameter.getOptions()) != null && !loptions.isEmpty()) {
                    for (ParameterOption option : loptions) {
                        String label = util.getParameterOptionLabel(bundle, uri, parameterName, option.getValue(), option.getLabel(), locale);
                        option = new ParameterOption(option.getValue(), label);
                    }
                }
                if ((lunitLabel = parameter.getUnitLabel()) != null) {
                    lunitLabel = util.getParameterUnitLabel(bundle, uri, parameterName, parameter.getUnit(), lunitLabel, locale);
                }
                configDescriptions.add(ConfigDescriptionParameterBuilder.create((String)parameterName, (ConfigDescriptionParameter.Type)parameter.getType()).withMinimum(parameter.getMinimum()).withMaximum(parameter.getMaximum()).withStepSize(parameter.getStepSize()).withPattern(lpattern).withRequired(Boolean.valueOf(parameter.isRequired())).withMultiple(parameter.isMultiple()).withReadOnly(parameter.isReadOnly()).withContext(parameter.getContext()).withDefault(parameter.getDefault()).withLabel(llabel).withDescription(ldescription).withFilterCriteria(parameter.getFilterCriteria()).withGroupName(parameter.getGroupName()).withAdvanced(Boolean.valueOf(parameter.isAdvanced())).withOptions(loptions).withLimitToOptions(Boolean.valueOf(parameter.getLimitToOptions())).withMultipleLimit(parameter.getMultipleLimit()).withUnit(parameter.getUnit()).withUnitLabel(lunitLabel).build());
            }
        }
        return configDescriptions;
    }

    /*
     * Loose catch block
     */
    protected Set<E> parseData(Parser<E> parser, URL url, Bundle bundle) {
        Set set;
        InputStream is;
        InputStreamReader reader;
        block27: {
            reader = null;
            is = null;
            is = url.openStream();
            reader = new InputStreamReader(is, StandardCharsets.UTF_8);
            set = parser.parse(reader);
            if (reader == null) break block27;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return set;
        catch (ParsingException e) {
            block28: {
                this.logger.error("{}", (Object)e.getLocalizedMessage(), (Object)e);
                if (reader == null) break block28;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e2) {
            block29: {
                this.logger.error("Can't read from resource of bundle with ID {}", (Object)bundle.getBundleId(), (Object)e2);
                this.processAutomationProviderUninstalled(bundle);
                if (reader == null) break block29;
                {
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewProvidedObjects(List<String> newPortfolio, List<String> previousPortfolio, Set<E> parsedObjects) {
        LinkedList<ProviderChangeListener<E>> snapshot = null;
        List<ProviderChangeListener<E>> list = this.listeners;
        synchronized (list) {
            snapshot = new LinkedList<ProviderChangeListener<E>>(this.listeners);
        }
        for (E parsedObject : parsedObjects) {
            String uid = this.getUID(parsedObject);
            E oldElement = this.providedObjectsHolder.get(uid);
            if (oldElement != null && !previousPortfolio.contains(uid)) {
                this.logger.warn("{} with UID '{}' already exists! Failed to add a second with the same UID!", (Object)parsedObject.getClass().getName(), (Object)uid);
                continue;
            }
            newPortfolio.add(uid);
            this.providedObjectsHolder.put(uid, parsedObject);
            for (ProviderChangeListener providerChangeListener : snapshot) {
                if (oldElement == null) {
                    providerChangeListener.added((Provider)this, parsedObject);
                    continue;
                }
                providerChangeListener.updated((Provider)this, oldElement, parsedObject);
            }
        }
    }

    protected void updateWaitingProviders(Parser<E> parser, Bundle bundle, URL url) {
        List<URL> urlList = this.waitingProviders.get(bundle);
        if (parser == null) {
            if (urlList == null) {
                urlList = new ArrayList<URL>();
            }
            urlList.add(url);
            this.waitingProviders.put(bundle, urlList);
            return;
        }
        if (urlList != null && urlList.remove(url) && urlList.isEmpty()) {
            this.waitingProviders.remove(bundle);
        }
    }

    protected abstract String getUID(E var1);
}

