/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.automation.ManagedRuleProvider;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.AutomationResourceBundlesEventQueue;
import org.eclipse.smarthome.automation.internal.core.provider.HostFragmentMappingUtil;
import org.eclipse.smarthome.automation.internal.core.provider.RuleResourceBundleImporter;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class AutomationResourceBundlesTracker
implements BundleTrackerCustomizer<Bundle> {
    private List<AutomationResourceBundlesEventQueue> providerEventsQueue = new ArrayList<AutomationResourceBundlesEventQueue>();
    protected RuleResourceBundleImporter rImporter;
    private BundleTracker<Bundle> bTracker;
    private List<BundleEvent> queue = new LinkedList<BundleEvent>();

    public AutomationResourceBundlesTracker() {
        this.rImporter = this.createImporter();
    }

    protected RuleResourceBundleImporter createImporter() {
        return new RuleResourceBundleImporter();
    }

    protected void activate(BundleContext bc) {
        this.bTracker = new BundleTracker(bc, -2, (BundleTrackerCustomizer)this);
        this.bTracker.open();
    }

    protected void deactivate(BundleContext bc) {
        this.bTracker.close();
        this.bTracker = null;
        this.rImporter.deactivate();
    }

    protected void addProvider(Provider provider) {
        if (provider instanceof AbstractResourceBundleProvider) {
            this.addAbstractResourceBundleProvider((AbstractResourceBundleProvider)provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAbstractResourceBundleProvider(AbstractResourceBundleProvider provider) {
        AutomationResourceBundlesEventQueue queue = provider.getQueue();
        List<BundleEvent> list = this.queue;
        synchronized (list) {
            queue.addAll(this.queue);
            this.providerEventsQueue.add(queue);
        }
    }

    protected void removeProvider(Provider provider) {
        if (provider instanceof AbstractResourceBundleProvider) {
            this.removeAbstractResourceBundleProvider((AbstractResourceBundleProvider)provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAbstractResourceBundleProvider(AbstractResourceBundleProvider provider) {
        AutomationResourceBundlesEventQueue queue = provider.getQueue();
        List<BundleEvent> list = this.queue;
        synchronized (list) {
            this.providerEventsQueue.remove(queue);
        }
    }

    protected void setManagedRuleProvider(ManagedRuleProvider mProvider) {
        this.rImporter.setManagedRuleProvider(mProvider);
        this.rImporter.activate(null);
        this.addAbstractResourceBundleProvider(this.rImporter);
    }

    protected void removeManagedRuleProvider(ManagedRuleProvider mProvider) {
        this.removeAbstractResourceBundleProvider(this.rImporter);
        this.rImporter.deactivate();
    }

    protected void addParser(Parser<Rule> parser, Map<String, String> properties) {
        this.rImporter.addParser(parser, properties);
    }

    protected void removeParser(Parser<Rule> parser, Map<String, String> properties) {
        this.rImporter.removeParser(parser, properties);
    }

    protected void setPackageAdmin(PackageAdmin pkgAdmin) {
        HostFragmentMappingUtil.pkgAdmin = pkgAdmin;
    }

    protected void removePackageAdmin(PackageAdmin pkgAdmin) {
        HostFragmentMappingUtil.pkgAdmin = null;
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        block4: {
            block2: {
                block3: {
                    if (!this.isAnAutomationProvider(bundle)) break block2;
                    if (!HostFragmentMappingUtil.isFragmentBundle(bundle)) break block3;
                    List<Bundle> hosts = HostFragmentMappingUtil.returnHostBundles(bundle);
                    if (!HostFragmentMappingUtil.needToProcessFragment(bundle, hosts)) break block4;
                    this.addEvent(bundle, event);
                    HostFragmentMappingUtil.fillHostFragmentMapping(hosts);
                    break block4;
                }
                HostFragmentMappingUtil.fillHostFragmentMapping(bundle);
                this.addEvent(bundle, event);
                break block4;
            }
            if (!HostFragmentMappingUtil.isFragmentBundle(bundle)) {
                List<Bundle> fragments = HostFragmentMappingUtil.fillHostFragmentMapping(bundle);
                for (Bundle fragment : fragments) {
                    if (!this.isAnAutomationProvider(fragment)) continue;
                    this.addEvent(bundle, event);
                    break;
                }
            }
        }
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        int type = event.getType();
        if (type == 8 || type == 32) {
            this.addEvent(bundle, event);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        if (HostFragmentMappingUtil.isFragmentBundle(bundle)) {
            for (Map.Entry<Bundle, List<Bundle>> entry : HostFragmentMappingUtil.getMapping()) {
                if (!entry.getValue().contains(bundle)) continue;
                Bundle host = entry.getKey();
                this.addEvent(host, new BundleEvent(8, host));
            }
        } else {
            this.addEvent(bundle, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(Bundle bundle, BundleEvent event) {
        BundleEvent e = event != null ? event : this.initializeEvent(bundle);
        List<BundleEvent> list = this.queue;
        synchronized (list) {
            this.queue.add(e);
            for (AutomationResourceBundlesEventQueue queue : this.providerEventsQueue) {
                queue.addEvent(bundle, e);
            }
        }
    }

    private BundleEvent initializeEvent(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return new BundleEvent(1, bundle);
            }
            case 4: {
                return new BundleEvent(32, bundle);
            }
        }
        return new BundleEvent(2, bundle);
    }

    private boolean isAnAutomationProvider(Bundle bundle) {
        return bundle.getEntryPaths(AbstractResourceBundleProvider.PATH) != null;
    }
}

