/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.binding.firmware;

import com.google.common.base.Preconditions;
import org.eclipse.smarthome.core.thing.ThingTypeUID;

public final class FirmwareUID {
    private ThingTypeUID thingTypeUID;
    private String firmwareVersion;

    protected FirmwareUID() {
    }

    public FirmwareUID(ThingTypeUID thingTypeUID, String firmwareVersion) {
        Preconditions.checkNotNull((Object)thingTypeUID, (Object)"Thing type UID must not be null.");
        Preconditions.checkArgument((firmwareVersion != null && !firmwareVersion.isEmpty() ? 1 : 0) != 0, (Object)"Firmware version must not be null or empty.");
        Preconditions.checkArgument((!firmwareVersion.contains(":") ? 1 : 0) != 0, (Object)"Firmware version must not consist of a colon.");
        this.thingTypeUID = thingTypeUID;
        this.firmwareVersion = firmwareVersion;
    }

    public ThingTypeUID getThingTypeUID() {
        return this.thingTypeUID;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firmwareVersion == null ? 0 : this.firmwareVersion.hashCode());
        result = 31 * result + (this.thingTypeUID == null ? 0 : this.thingTypeUID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUID other = (FirmwareUID)obj;
        if (this.firmwareVersion == null ? other.firmwareVersion != null : !this.firmwareVersion.equals(other.firmwareVersion)) {
            return false;
        }
        return !(this.thingTypeUID == null ? other.thingTypeUID != null : !this.thingTypeUID.equals(other.thingTypeUID));
    }

    public String toString() {
        return "FirmwareUID [thingTypeUID=" + this.thingTypeUID + ", firmwareVersion=" + this.firmwareVersion + "]";
    }
}

