/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={FirmwareRegistry.class})
public final class FirmwareRegistry {
    private final Logger logger = LoggerFactory.getLogger(FirmwareRegistry.class);
    private final List<FirmwareProvider> firmwareProviders = new CopyOnWriteArrayList<FirmwareProvider>();
    private LocaleProvider localeProvider;

    public Firmware getFirmware(FirmwareUID firmwareUID) {
        return this.getFirmware(firmwareUID, this.localeProvider.getLocale());
    }

    public Firmware getFirmware(FirmwareUID firmwareUID, Locale locale) {
        Preconditions.checkNotNull((Object)firmwareUID, (Object)"Firmware UID must not be null");
        Locale loc = locale != null ? locale : this.localeProvider.getLocale();
        for (FirmwareProvider firmwareProvider : this.firmwareProviders) {
            try {
                Firmware firmware = firmwareProvider.getFirmware(firmwareUID, loc);
                if (firmware == null) continue;
                return firmware;
            }
            catch (Exception e) {
                this.logger.warn("Unexpected exception occurred for firmware provider {} while getting firmware for firmware UID {}.", new Object[]{firmwareProvider.getClass().getSimpleName(), firmwareUID, e});
            }
        }
        return null;
    }

    public Firmware getLatestFirmware(ThingTypeUID thingTypeUID) {
        return this.getLatestFirmware(thingTypeUID, this.localeProvider.getLocale());
    }

    public Firmware getLatestFirmware(ThingTypeUID thingTypeUID, Locale locale) {
        Locale loc = locale != null ? locale : this.localeProvider.getLocale();
        return (Firmware)Iterables.getFirst(this.getFirmwares(thingTypeUID, loc), null);
    }

    public Collection<Firmware> getFirmwares(ThingTypeUID thingTypeUID) {
        return this.getFirmwares(thingTypeUID, this.localeProvider.getLocale());
    }

    public Collection<Firmware> getFirmwares(ThingTypeUID thingTypeUID, Locale locale) {
        Preconditions.checkNotNull((Object)thingTypeUID, (Object)"Thing type UID must not be null");
        Locale loc = locale != null ? locale : this.localeProvider.getLocale();
        TreeSet<Firmware> firmwares = new TreeSet<Firmware>();
        for (FirmwareProvider firmwareProvider : this.firmwareProviders) {
            try {
                Set<Firmware> result = firmwareProvider.getFirmwares(thingTypeUID, loc);
                if (result == null) continue;
                firmwares.addAll(result);
            }
            catch (Exception e) {
                this.logger.warn("Unexpected exception occurred for firmware provider {} while getting firmwares for thing type UID {}.", new Object[]{firmwareProvider.getClass().getSimpleName(), thingTypeUID, e});
            }
        }
        return Collections.unmodifiableCollection(firmwares);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addFirmwareProvider(FirmwareProvider firmwareProvider) {
        this.firmwareProviders.add(firmwareProvider);
    }

    protected void removeFirmwareProvider(FirmwareProvider firmwareProvider) {
        this.firmwareProviders.remove(firmwareProvider);
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }
}

