/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResult;

public final class FirmwareUpdateResultInfo {
    private FirmwareUpdateResult result;
    private String errorMessage;

    protected FirmwareUpdateResultInfo() {
    }

    FirmwareUpdateResultInfo(FirmwareUpdateResult result, String errorMessage) {
        Preconditions.checkNotNull((Object)((Object)result), (Object)"Firmware update result must not be null");
        this.result = result;
        if (result != FirmwareUpdateResult.SUCCESS) {
            Preconditions.checkArgument((errorMessage != null && !errorMessage.isEmpty() ? 1 : 0) != 0, (Object)"Error message must not be null or empty for erroneous firmare updates");
            this.errorMessage = errorMessage;
        }
    }

    public FirmwareUpdateResult getResult() {
        return this.result;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUpdateResultInfo other = (FirmwareUpdateResultInfo)obj;
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        return this.result == other.result;
    }

    public String toString() {
        return "FirmwareUpdateResultInfo [result=" + (Object)((Object)this.result) + ", errorMessage=" + this.errorMessage + "]";
    }
}

