/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.DynamicStateDescriptionProvider;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"service.ranking:Integer=-1"})
public class ChannelStateDescriptionProvider
implements StateDescriptionProvider {
    private final Logger logger = LoggerFactory.getLogger(ChannelStateDescriptionProvider.class);
    private List<DynamicStateDescriptionProvider> dynamicStateDescriptionProviders = new CopyOnWriteArrayList<DynamicStateDescriptionProvider>();
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ThingTypeRegistry thingTypeRegistry;
    private ThingRegistry thingRegistry;
    private Integer rank;

    @Activate
    protected void activate(Map<String, Object> properties) {
        Object serviceRanking = properties.get("service.ranking");
        this.rank = serviceRanking instanceof Integer ? (Integer)serviceRanking : Integer.valueOf(0);
    }

    public Integer getRank() {
        return this.rank;
    }

    public StateDescription getStateDescription(String itemName, Locale locale) {
        ChannelUID channelUID;
        Channel channel;
        Set<ChannelUID> boundChannels = this.itemChannelLinkRegistry.getBoundChannels(itemName);
        if (!boundChannels.isEmpty() && (channel = this.thingRegistry.getChannel(channelUID = boundChannels.iterator().next())) != null) {
            StateDescription dynamicStateDescription;
            StateDescription stateDescription = null;
            ChannelType channelType = this.thingTypeRegistry.getChannelType(channel, locale);
            if (channelType != null) {
                stateDescription = channelType.getState();
                if (channelType.getItemType() != null && (stateDescription == null || stateDescription.getPattern() == null)) {
                    String pattern = null;
                    if (channelType.getItemType().equalsIgnoreCase("String")) {
                        pattern = "%s";
                    } else if (channelType.getItemType().equalsIgnoreCase("Number")) {
                        pattern = "%.0f";
                    }
                    if (pattern != null) {
                        this.logger.trace("Provide a default pattern {} for item {}", (Object)pattern, (Object)itemName);
                        stateDescription = stateDescription == null ? new StateDescription(null, null, null, pattern, false, null) : new StateDescription(stateDescription.getMinimum(), stateDescription.getMaximum(), stateDescription.getStep(), pattern, stateDescription.isReadOnly(), stateDescription.getOptions());
                    }
                }
            }
            if ((dynamicStateDescription = this.getDynamicStateDescription(channel, stateDescription, locale)) != null) {
                return dynamicStateDescription;
            }
            return stateDescription;
        }
        return null;
    }

    private StateDescription getDynamicStateDescription(Channel channel, StateDescription originalStateDescription, Locale locale) {
        for (DynamicStateDescriptionProvider provider : this.dynamicStateDescriptionProviders) {
            StateDescription stateDescription = provider.getStateDescription(channel, originalStateDescription, locale);
            if (stateDescription == null) continue;
            return stateDescription;
        }
        return null;
    }

    @Reference
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addDynamicStateDescriptionProvider(DynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        this.dynamicStateDescriptionProviders.add(dynamicStateDescriptionProvider);
    }

    protected void removeDynamicStateDescriptionProvider(DynamicStateDescriptionProvider dynamicStateDescriptionProvider) {
        this.dynamicStateDescriptionProviders.remove(dynamicStateDescriptionProvider);
    }
}

