/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.javasound.internal;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import org.apache.commons.collections.Closure;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.core.audio.AudioFormat;
import org.eclipse.smarthome.core.audio.AudioSink;
import org.eclipse.smarthome.core.audio.AudioStream;
import org.eclipse.smarthome.core.audio.UnsupportedAudioFormatException;
import org.eclipse.smarthome.core.audio.UnsupportedAudioStreamException;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.io.javasound.internal.AudioPlayer;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSoundAudioSink
implements AudioSink {
    private final Logger logger = LoggerFactory.getLogger(JavaSoundAudioSink.class);
    private boolean isMac = false;
    private PercentType macVolumeValue = null;
    private static final HashSet<Class<? extends AudioStream>> SUPPORTED_AUDIO_STREAMS = new HashSet();

    static {
        SUPPORTED_AUDIO_STREAMS.add(AudioStream.class);
    }

    protected void activate(BundleContext context) {
        String os = context.getProperty("org.osgi.framework.os.name");
        if (os != null && os.toLowerCase().startsWith("macos")) {
            this.isMac = true;
        }
    }

    public void process(AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        AudioPlayer audioPlayer = new AudioPlayer(audioStream);
        audioPlayer.start();
        try {
            audioPlayer.join();
        }
        catch (InterruptedException interruptedException) {
            this.logger.error("Playing audio has been interrupted.");
        }
    }

    public Set<AudioFormat> getSupportedFormats() {
        AudioFormat format = new AudioFormat("WAVE", "PCM_SIGNED", null, null, null, null);
        return Collections.singleton(format);
    }

    public Set<Class<? extends AudioStream>> getSupportedStreams() {
        return SUPPORTED_AUDIO_STREAMS;
    }

    public String getId() {
        return "javasound";
    }

    public String getLabel(Locale locale) {
        return "System Speaker";
    }

    public PercentType getVolume() throws IOException {
        if (!this.isMac) {
            final Float[] volumes = new Float[1];
            this.runVolumeCommand(new Closure(){

                public void execute(Object input) {
                    FloatControl volumeControl = (FloatControl)input;
                    volumes[0] = Float.valueOf(volumeControl.getValue());
                }
            });
            if (volumes[0] != null) {
                return new PercentType(new BigDecimal(volumes[0].floatValue() * 100.0f));
            }
            throw new IOException("Cannot determine master volume level");
        }
        if (this.macVolumeValue == null) {
            Process p = Runtime.getRuntime().exec(new String[]{"osascript", "-e", "output volume of (get volume settings)"});
            String value = IOUtils.toString((InputStream)p.getInputStream()).trim();
            this.macVolumeValue = new PercentType(value);
        }
        return this.macVolumeValue;
    }

    public void setVolume(final PercentType volume) throws IOException {
        if (volume.intValue() < 0 || volume.intValue() > 100) {
            throw new IllegalArgumentException("Volume value must be in the range [0,100]!");
        }
        if (!this.isMac) {
            this.runVolumeCommand(new Closure(){

                public void execute(Object input) {
                    FloatControl volumeControl = (FloatControl)input;
                    volumeControl.setValue(volume.floatValue() / 100.0f);
                }
            });
        } else {
            Runtime.getRuntime().exec(new String[]{"osascript", "-e", "set volume output volume " + volume.intValue()});
            this.macVolumeValue = volume;
        }
    }

    private void runVolumeCommand(Closure closure) {
        Mixer.Info[] infos;
        Mixer.Info[] infoArray = infos = AudioSystem.getMixerInfo();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info info = infoArray[n2];
            Mixer mixer = AudioSystem.getMixer(info);
            if (mixer.isLineSupported(Port.Info.SPEAKER)) {
                try {
                    Port port = (Port)mixer.getLine(Port.Info.SPEAKER);
                    port.open();
                    if (port.isControlSupported(FloatControl.Type.VOLUME)) {
                        FloatControl volume = (FloatControl)port.getControl(FloatControl.Type.VOLUME);
                        closure.execute((Object)volume);
                    }
                    port.close();
                }
                catch (LineUnavailableException e) {
                    this.logger.error("Cannot access master volume control", (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

