/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.internal.items;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.RegistryHook;
import org.eclipse.smarthome.core.library.items.CallItem;
import org.eclipse.smarthome.core.library.items.ColorItem;
import org.eclipse.smarthome.core.library.items.ContactItem;
import org.eclipse.smarthome.core.library.items.DateTimeItem;
import org.eclipse.smarthome.core.library.items.DimmerItem;
import org.eclipse.smarthome.core.library.items.ImageItem;
import org.eclipse.smarthome.core.library.items.LocationItem;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.items.PlayerItem;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.core.library.items.StringItem;
import org.eclipse.smarthome.core.library.items.SwitchItem;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.NextPreviousType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.model.sitemap.ColorArray;
import org.eclipse.smarthome.model.sitemap.Default;
import org.eclipse.smarthome.model.sitemap.Group;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapFactory;
import org.eclipse.smarthome.model.sitemap.Slider;
import org.eclipse.smarthome.model.sitemap.Switch;
import org.eclipse.smarthome.model.sitemap.VisibilityRule;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.internal.UIActivator;
import org.eclipse.smarthome.ui.items.ItemUIProvider;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemUIRegistryImpl
implements ItemUIRegistry {
    private final Logger logger = LoggerFactory.getLogger(ItemUIRegistryImpl.class);
    protected static final String IMAGE_LOCATION = "./webapps/images/";
    protected static final Pattern EXTRACT_TRANSFORMFUNCTION_PATTERN = Pattern.compile("\\[(.*?)\\((.*)\\):(.*)\\]");
    protected static final String IDENTIFY_FORMAT_PATTERN_PATTERN = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z])";
    protected Set<ItemUIProvider> itemUIProviders = new HashSet<ItemUIProvider>();
    protected ItemRegistry itemRegistry;
    private final Map<Widget, Widget> defaultWidgets = Collections.synchronizedMap(new WeakHashMap());

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    public void addItemUIProvider(ItemUIProvider itemUIProvider) {
        this.itemUIProviders.add(itemUIProvider);
    }

    public void removeItemUIProvider(ItemUIProvider itemUIProvider) {
        this.itemUIProviders.remove(itemUIProvider);
    }

    @Override
    public String getCategory(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            String currentCategory = provider.getCategory(itemName);
            if (currentCategory == null) continue;
            return currentCategory;
        }
        String category = this.getItemCategory(itemName);
        if (category != null) {
            return category.toLowerCase();
        }
        Class<? extends Item> itemType = this.getItemType(itemName);
        if (itemType == null) {
            return null;
        }
        if (itemType.equals(NumberItem.class) || itemType.equals(ContactItem.class) || itemType.equals(RollershutterItem.class)) {
            return itemType.getSimpleName().replace("Item", "").toLowerCase();
        }
        return null;
    }

    @Override
    public String getLabel(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            String currentLabel = provider.getLabel(itemName);
            if (currentLabel == null) continue;
            return currentLabel;
        }
        try {
            Item item = this.getItem(itemName);
            if (item.getLabel() != null) {
                return item.getLabel();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Widget getWidget(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            Widget currentWidget = provider.getWidget(itemName);
            if (currentWidget == null) continue;
            return this.resolveDefault(currentWidget);
        }
        return null;
    }

    @Override
    public Widget getDefaultWidget(Class<? extends Item> targetItemType, String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            Widget widget = provider.getDefaultWidget(targetItemType, itemName);
            if (widget == null) continue;
            return widget;
        }
        Class<? extends Item> itemType = targetItemType;
        if (itemType == null) {
            itemType = this.getItemType(itemName);
        }
        if (itemType == null) {
            return null;
        }
        if (itemType.equals(SwitchItem.class)) {
            return SitemapFactory.eINSTANCE.createSwitch();
        }
        if (itemType.equals(GroupItem.class)) {
            return SitemapFactory.eINSTANCE.createGroup();
        }
        if (NumberItem.class.isAssignableFrom(itemType)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(ContactItem.class)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(DateTimeItem.class)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(RollershutterItem.class)) {
            return SitemapFactory.eINSTANCE.createSwitch();
        }
        if (itemType.equals(StringItem.class)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(LocationItem.class)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(CallItem.class)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (itemType.equals(DimmerItem.class)) {
            Slider slider = SitemapFactory.eINSTANCE.createSlider();
            slider.setSwitchEnabled(true);
            return slider;
        }
        if (itemType.equals(ColorItem.class)) {
            return SitemapFactory.eINSTANCE.createColorpicker();
        }
        if (itemType.equals(PlayerItem.class)) {
            return this.createPlayerButtons();
        }
        if (itemType.equals(ImageItem.class)) {
            return SitemapFactory.eINSTANCE.createImage();
        }
        return null;
    }

    private Switch createPlayerButtons() {
        Switch playerItemSwitch = SitemapFactory.eINSTANCE.createSwitch();
        EList mappings = playerItemSwitch.getMappings();
        Mapping commandMapping = null;
        commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(NextPreviousType.PREVIOUS.name());
        commandMapping.setLabel("<<");
        commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(PlayPauseType.PAUSE.name());
        commandMapping.setLabel("||");
        commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(PlayPauseType.PLAY.name());
        commandMapping.setLabel(">");
        commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(NextPreviousType.NEXT.name());
        commandMapping.setLabel(">>");
        return playerItemSwitch;
    }

    @Override
    public String getLabel(Widget w) {
        String label = this.getLabelFromWidget(w);
        String labelMappedOption = null;
        String itemName = w.getItem();
        if (itemName != null) {
            State state = null;
            String formatPattern = this.getFormatPattern(label);
            StateDescription stateDescription = null;
            try {
                String updatedPattern;
                String pattern;
                Item item = this.getItem(itemName);
                stateDescription = item.getStateDescription();
                if (formatPattern == null && stateDescription != null && (pattern = stateDescription.getPattern()) != null) {
                    label = String.valueOf(label) + " [" + pattern + "]";
                }
                if ((updatedPattern = this.getFormatPattern(label)) != null && !(formatPattern = updatedPattern).isEmpty()) {
                    if (label.contains("%d")) {
                        state = item.getState();
                        if (!(state instanceof DecimalType)) {
                            state = item.getStateAs(DecimalType.class);
                        }
                    } else {
                        state = item.getState();
                    }
                }
            }
            catch (ItemNotFoundException e) {
                this.logger.error("Cannot retrieve item for widget {}", (Object)w.eClass().getInstanceTypeName());
            }
            if (formatPattern != null) {
                if (formatPattern.isEmpty()) {
                    label = label.substring(0, label.indexOf("[")).trim();
                } else {
                    if (state == null || state instanceof UnDefType) {
                        formatPattern = this.formatUndefined(formatPattern);
                    } else if (state instanceof Type) {
                        if (stateDescription != null && stateDescription.getOptions() != null) {
                            for (StateOption option : stateDescription.getOptions()) {
                                if (!option.getValue().equals(state.toString()) || option.getLabel() == null) continue;
                                StringType stateOption = new StringType(option.getLabel());
                                try {
                                    String formatPatternOption = stateOption.format(formatPattern);
                                    labelMappedOption = label.trim();
                                    labelMappedOption = String.valueOf(labelMappedOption.substring(0, labelMappedOption.indexOf("[") + 1)) + formatPatternOption + "]";
                                }
                                catch (IllegalArgumentException e) {
                                    this.logger.debug("Mapping option value '{}' for item {} using format '{}' failed ({}); mapping is ignored", new Object[]{stateOption, itemName, formatPattern, e.getMessage()});
                                    labelMappedOption = null;
                                }
                                break;
                            }
                        }
                        try {
                            formatPattern = state.format(formatPattern);
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.warn("Exception while formatting value '{}' of item {} with format '{}': {}", new Object[]{state, itemName, formatPattern, e});
                            formatPattern = new String("Err");
                        }
                    }
                    label = label.trim();
                    label = String.valueOf(label.substring(0, label.indexOf("[") + 1)) + formatPattern + "]";
                }
            }
        }
        label = this.transform(label, labelMappedOption);
        return label;
    }

    private String getFormatPattern(String label) {
        int indexCloseBracket;
        String pattern = label.trim();
        int indexOpenBracket = pattern.indexOf("[");
        int n = indexCloseBracket = pattern.endsWith("]") ? pattern.length() - 1 : -1;
        if (indexOpenBracket >= 0 && indexCloseBracket > indexOpenBracket) {
            return pattern.substring(indexOpenBracket + 1, indexCloseBracket);
        }
        return null;
    }

    private String getLabelFromWidget(Widget w) {
        String label = null;
        if (w.getLabel() != null) {
            label = w.getLabel();
        } else {
            String itemName = w.getItem();
            if (itemName != null && (label = this.getLabel(itemName)) == null) {
                label = itemName;
            }
        }
        return label != null ? label : "";
    }

    protected String formatUndefined(String formatPattern) {
        String undefinedFormatPattern = formatPattern.replaceAll(IDENTIFY_FORMAT_PATTERN_PATTERN, "%1\\$s");
        try {
            return String.format(undefinedFormatPattern, "-");
        }
        catch (Exception e) {
            this.logger.warn("Exception while formatting undefined value [sourcePattern={}, targetPattern={}, {}]", new Object[]{formatPattern, undefinedFormatPattern, e});
            return "Err";
        }
    }

    private String transform(String label, String labelMappedOption) {
        String ret = label;
        if (this.getFormatPattern(label) != null) {
            Matcher matcher = EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(label);
            if (matcher.find()) {
                String type = matcher.group(1);
                String pattern = matcher.group(2);
                String value = matcher.group(3);
                TransformationService transformation = TransformationHelper.getTransformationService((BundleContext)UIActivator.getContext(), (String)type);
                if (transformation != null) {
                    try {
                        ret = String.valueOf(label.substring(0, label.indexOf("[") + 1)) + transformation.transform(pattern, value) + "]";
                    }
                    catch (TransformationException e) {
                        this.logger.error("transformation throws exception [transformation={}, value={}]", new Object[]{transformation, value, e});
                        ret = String.valueOf(label.substring(0, label.indexOf("[") + 1)) + value + "]";
                    }
                } else {
                    this.logger.warn("couldn't transform value in label because transformationService of type '{}' is unavailable", (Object)type);
                    ret = String.valueOf(label.substring(0, label.indexOf("[") + 1)) + value + "]";
                }
            } else if (labelMappedOption != null) {
                ret = labelMappedOption;
            }
        }
        return ret;
    }

    @Override
    public String getCategory(Widget w) {
        String widgetTypeName = w.eClass().getInstanceTypeName().substring(w.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
        String category = widgetTypeName.toLowerCase();
        if (w.getIcon() != null) {
            category = w.getIcon();
        } else {
            String result;
            String itemName = w.getItem();
            if (itemName != null && (result = this.getCategory(itemName)) != null) {
                category = result;
            }
        }
        return category;
    }

    @Override
    public State getState(Widget w) {
        String itemName = w.getItem();
        if (itemName != null) {
            try {
                Item item = this.getItem(itemName);
                return this.convertState(w, item);
            }
            catch (ItemNotFoundException e) {
                this.logger.error("Cannot retrieve item '{}' for widget {}", new Object[]{itemName, w.eClass().getInstanceTypeName()});
            }
        }
        return UnDefType.UNDEF;
    }

    private State convertState(Widget w, Item i) {
        Switch sw;
        State returnState = null;
        if (w instanceof Switch && i instanceof RollershutterItem) {
            returnState = i.getStateAs(PercentType.class);
        } else if (w instanceof Slider) {
            returnState = i.getAcceptedDataTypes().contains(PercentType.class) ? i.getStateAs(PercentType.class) : i.getStateAs(DecimalType.class);
        } else if (w instanceof Switch && (sw = (Switch)w).getMappings().size() == 0) {
            returnState = i.getStateAs(OnOffType.class);
        }
        if (returnState == null) {
            returnState = i.getState();
        }
        return returnState;
    }

    @Override
    public Widget getWidget(Sitemap sitemap, String id) {
        if (id.length() > 0) {
            Widget w = this.getWidget(id);
            if (w == null) {
                w = this.getDefaultWidget(null, id);
            }
            if (w != null) {
                w.setItem(id);
            } else {
                try {
                    int widgetID = Integer.valueOf(id.substring(0, 2));
                    if (widgetID < sitemap.getChildren().size()) {
                        w = (Widget)sitemap.getChildren().get(widgetID);
                        int i = 2;
                        while (i < id.length()) {
                            int childWidgetID = Integer.valueOf(id.substring(i, i + 2));
                            if (childWidgetID < ((LinkableWidget)w).getChildren().size()) {
                                w = (Widget)((LinkableWidget)w).getChildren().get(childWidgetID);
                            }
                            i += 2;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.resolveDefault(w);
        }
        this.logger.warn("Cannot find page for id '{}'.", (Object)id);
        return null;
    }

    @Override
    public EList<Widget> getChildren(Sitemap sitemap) {
        EList widgets = sitemap.getChildren();
        BasicEList result = new BasicEList();
        for (Widget widget : widgets) {
            Widget resolvedWidget = this.resolveDefault(widget);
            if (resolvedWidget == null) continue;
            result.add((Object)resolvedWidget);
        }
        return result;
    }

    @Override
    public EList<Widget> getChildren(LinkableWidget w) {
        EList<Widget> widgets = null;
        widgets = w instanceof Group && w.getChildren().isEmpty() ? this.getDynamicGroupChildren((Group)w) : w.getChildren();
        BasicEList result = new BasicEList();
        for (Widget widget : widgets) {
            Widget resolvedWidget = this.resolveDefault(widget);
            if (resolvedWidget == null) continue;
            result.add((Object)resolvedWidget);
        }
        return result;
    }

    @Override
    public EObject getParent(Widget w) {
        Widget w2 = this.defaultWidgets.get(w);
        return w2 == null ? w.eContainer() : w2.eContainer();
    }

    private Widget resolveDefault(Widget widget) {
        Widget defaultWidget;
        Item item;
        if (!(widget instanceof Default)) {
            return widget;
        }
        String itemName = widget.getItem();
        if (itemName != null && (item = (Item)this.itemRegistry.get((Object)itemName)) != null && (defaultWidget = this.getDefaultWidget(item.getClass(), item.getName())) != null) {
            this.copyProperties(widget, defaultWidget);
            this.defaultWidgets.put(defaultWidget, widget);
            return defaultWidget;
        }
        return null;
    }

    private void copyProperties(Widget source, Widget target) {
        target.setItem(source.getItem());
        target.setIcon(source.getIcon());
        target.setLabel(source.getLabel());
        target.getVisibility().addAll(EcoreUtil.copyAll((Collection)source.getVisibility()));
        target.getLabelColor().addAll(EcoreUtil.copyAll((Collection)source.getLabelColor()));
        target.getValueColor().addAll(EcoreUtil.copyAll((Collection)source.getValueColor()));
    }

    private EList<Widget> getDynamicGroupChildren(Group group) {
        BasicEList children = new BasicEList();
        String itemName = group.getItem();
        try {
            if (itemName != null) {
                Item item = this.getItem(itemName);
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getMembers()) {
                        Widget widget = this.getDefaultWidget(member.getClass(), member.getName());
                        if (widget == null) continue;
                        widget.setItem(member.getName());
                        children.add((Object)widget);
                    }
                } else {
                    this.logger.warn("Item '{}' is not a group.", (Object)item.getName());
                }
            } else {
                this.logger.warn("Group does not specify an associated item - ignoring it.");
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Group '{}' could not be found.", (Object)group.getLabel(), (Object)e);
        }
        return children;
    }

    private Class<? extends Item> getItemType(@NonNull String itemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            return item.getClass();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    @Override
    public State getItemState(String itemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            return item.getState();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public String getItemCategory(@NonNull String itemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            return item.getCategory();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public Item getItem(String name) throws ItemNotFoundException {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItem(name);
        }
        throw new ItemNotFoundException(name);
    }

    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItemByPattern(name);
        }
        throw new ItemNotFoundException(name);
    }

    public Collection<Item> getItems() {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItems();
        }
        return Collections.emptyList();
    }

    public Collection<Item> getItemsOfType(String type) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItemsOfType(type);
        }
        return Collections.emptyList();
    }

    public Collection<Item> getItems(String pattern) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItems(pattern);
        }
        return Collections.emptyList();
    }

    public void addRegistryChangeListener(RegistryChangeListener<Item> listener) {
        if (this.itemRegistry != null) {
            this.itemRegistry.addRegistryChangeListener(listener);
        }
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Item> listener) {
        if (this.itemRegistry != null) {
            this.itemRegistry.removeRegistryChangeListener(listener);
        }
    }

    public Collection<Item> getAll() {
        return this.itemRegistry.getAll();
    }

    public Stream<Item> stream() {
        return this.itemRegistry.stream();
    }

    @Override
    public String getWidgetId(Widget widget) {
        String index;
        Widget w2 = this.defaultWidgets.get(widget);
        if (w2 != null) {
            return this.getWidgetId(w2);
        }
        String id = "";
        Widget w = widget;
        while (w.eContainer() instanceof Widget) {
            Widget parent = (Widget)w.eContainer();
            index = String.valueOf(((LinkableWidget)parent).getChildren().indexOf((Object)w));
            if (index.length() == 1) {
                index = "0" + index;
            }
            id = String.valueOf(index) + id;
            w = parent;
        }
        if (w.eContainer() instanceof Sitemap) {
            Sitemap sitemap = (Sitemap)w.eContainer();
            index = String.valueOf(sitemap.getChildren().indexOf((Object)w));
            if (index.length() == 1) {
                index = "0" + index;
            }
            id = String.valueOf(index) + id;
        }
        if (w.eContainer() == null) {
            String itemName;
            id = itemName = w.getItem();
        }
        return id;
    }

    private boolean matchStateToValue(State state, String value, String matchCondition) {
        boolean matched = false;
        String unquotedValue = value;
        if (unquotedValue.startsWith("\"") && unquotedValue.endsWith("\"")) {
            unquotedValue = unquotedValue.substring(1, unquotedValue.length() - 1);
        }
        Condition condition = Condition.EQUAL;
        if (matchCondition != null) {
            condition = Condition.fromString(matchCondition);
        }
        if (DecimalType.class.isInstance(state)) {
            try {
                switch (condition) {
                    case EQUAL: {
                        if (Double.parseDouble(state.toString()) == Double.parseDouble(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case LTE: {
                        if (Double.parseDouble(state.toString()) <= Double.parseDouble(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case GTE: {
                        if (Double.parseDouble(state.toString()) >= Double.parseDouble(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case GREATER: {
                        if (Double.parseDouble(state.toString()) > Double.parseDouble(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case LESS: {
                        if (Double.parseDouble(state.toString()) < Double.parseDouble(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case NOTEQUAL: 
                    case NOT: {
                        if (Double.parseDouble(state.toString()) == Double.parseDouble(unquotedValue)) break;
                        matched = true;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.logger.debug("matchStateToValue: Decimal format exception: ", (Throwable)e);
            }
        } else if (state instanceof DateTimeType) {
            ZonedDateTime val = ((DateTimeType)state).getZonedDateTime();
            ZonedDateTime now = ZonedDateTime.now();
            long secsDif = ChronoUnit.SECONDS.between(now, val);
            try {
                switch (condition) {
                    case EQUAL: {
                        if (secsDif == (long)Integer.parseInt(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case LTE: {
                        if (secsDif <= (long)Integer.parseInt(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case GTE: {
                        if (secsDif >= (long)Integer.parseInt(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case GREATER: {
                        if (secsDif > (long)Integer.parseInt(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case LESS: {
                        if (secsDif < (long)Integer.parseInt(unquotedValue)) {
                            matched = true;
                        }
                        break;
                    }
                    case NOTEQUAL: 
                    case NOT: {
                        if (secsDif == (long)Integer.parseInt(unquotedValue)) break;
                        matched = true;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                this.logger.debug("matchStateToValue: Decimal format exception: ", (Throwable)e);
            }
        } else {
            switch (condition) {
                case NOTEQUAL: 
                case NOT: {
                    if (unquotedValue.equals(state.toString())) break;
                    matched = true;
                    break;
                }
                default: {
                    if (!unquotedValue.equals(state.toString())) break;
                    matched = true;
                }
            }
        }
        return matched;
    }

    private String processColorDefinition(State state, List<ColorArray> colorList) {
        if (colorList == null) {
            return null;
        }
        if (colorList.size() == 0) {
            return null;
        }
        String colorString = null;
        if (colorList.size() == 1 && colorList.get(0).getState() == null) {
            colorString = colorList.get(0).getArg();
        } else {
            for (ColorArray color : colorList) {
                String value;
                State cmpState = state;
                if (color.getState() == null) {
                    this.logger.error("Error parsing color");
                    continue;
                }
                String itemName = color.getItem();
                if (itemName != null) {
                    try {
                        Item item = this.itemRegistry.getItem(itemName);
                        cmpState = item.getState();
                    }
                    catch (ItemNotFoundException e) {
                        this.logger.warn("Cannot retrieve color item {} for widget", (Object)color.getItem());
                    }
                }
                if (!this.matchStateToValue(cmpState, value = color.getSign() != null ? String.valueOf(color.getSign()) + color.getState() : color.getState(), color.getCondition())) continue;
                colorString = color.getArg();
                break;
            }
        }
        if (colorString == null) {
            return null;
        }
        if (colorString.startsWith("\"") && colorString.endsWith("\"")) {
            colorString = colorString.substring(1, colorString.length() - 1);
        }
        return colorString;
    }

    @Override
    public String getLabelColor(Widget w) {
        return this.processColorDefinition(this.getState(w), (List<ColorArray>)w.getLabelColor());
    }

    @Override
    public String getValueColor(Widget w) {
        return this.processColorDefinition(this.getState(w), (List<ColorArray>)w.getValueColor());
    }

    @Override
    public boolean getVisiblity(Widget w) {
        EList ruleList = w.getVisibility();
        if (ruleList == null) {
            return true;
        }
        if (ruleList.size() == 0) {
            return true;
        }
        this.logger.debug("Checking visiblity for widget '{}'.", (Object)w.getLabel());
        for (VisibilityRule rule : w.getVisibility()) {
            Item item;
            String itemName = rule.getItem();
            if (itemName == null || rule.getState() == null) continue;
            try {
                item = this.itemRegistry.getItem(itemName);
            }
            catch (ItemNotFoundException e) {
                this.logger.error("Cannot retrieve visibility item {} for widget {}", (Object)rule.getItem(), (Object)w.eClass().getInstanceTypeName());
                return true;
            }
            State state = item.getState();
            String value = rule.getSign() != null ? String.valueOf(rule.getSign()) + rule.getState() : rule.getState();
            if (!this.matchStateToValue(state, value, rule.getCondition())) continue;
            return true;
        }
        this.logger.debug("Widget {} is not visible.", (Object)w.getLabel());
        return false;
    }

    public Collection<Item> getItemsByTag(String ... tags) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItemsByTag(tags);
        }
        return Collections.emptyList();
    }

    public Collection<Item> getItemsByTagAndType(String type, String ... tags) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItemsByTagAndType(type, tags);
        }
        return Collections.emptyList();
    }

    public <T extends GenericItem> Collection<T> getItemsByTag(Class<T> typeFilter, String ... tags) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.getItemsByTag(typeFilter, tags);
        }
        return Collections.emptyList();
    }

    public Item add(Item element) {
        if (this.itemRegistry != null) {
            return (Item)this.itemRegistry.add((Identifiable)element);
        }
        return element;
    }

    public Item update(Item element) {
        if (this.itemRegistry != null) {
            return (Item)this.itemRegistry.update((Identifiable)element);
        }
        return null;
    }

    public Item remove(String key) {
        if (this.itemRegistry != null) {
            return (Item)this.itemRegistry.remove((Object)key);
        }
        return null;
    }

    public Item get(String key) {
        if (this.itemRegistry != null) {
            return (Item)this.itemRegistry.get((Object)key);
        }
        return null;
    }

    public Item remove(String itemName, boolean recursive) {
        if (this.itemRegistry != null) {
            return this.itemRegistry.remove(itemName, recursive);
        }
        return null;
    }

    public void addRegistryHook(RegistryHook<Item> hook) {
        if (this.itemRegistry != null) {
            this.itemRegistry.addRegistryHook(hook);
        }
    }

    public void removeRegistryHook(RegistryHook<Item> hook) {
        if (this.itemRegistry != null) {
            this.itemRegistry.removeRegistryHook(hook);
        }
    }

    static enum Condition {
        EQUAL("=="),
        GTE(">="),
        LTE("<="),
        NOTEQUAL("!="),
        GREATER(">"),
        LESS("<"),
        NOT("!");

        private String value;

        private Condition(String value) {
            this.value = value;
        }

        public static Condition fromString(String text) {
            if (text != null) {
                Condition[] conditionArray = Condition.values();
                int n = conditionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Condition c = conditionArray[n2];
                    if (text.equalsIgnoreCase(c.value)) {
                        return c;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

