/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.voice.Voice;
import org.eclipse.smarthome.core.voice.VoiceManager;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;

public class VoiceConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_SAY = "say";
    private static final String SUBCMD_INTERPRET = "interpret";
    private static final String SUBCMD_VOICES = "voices";
    private ItemRegistry itemRegistry;
    private VoiceManager voiceManager;

    public VoiceConsoleCommandExtension() {
        super("voice", "Commands around voice enablement features.");
    }

    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("say <text>", "speaks a text"), this.buildCommandUsage("interpret <command>", "interprets a human language command"), this.buildCommandUsage(SUBCMD_VOICES, "lists available voices of the active TTS service"));
    }

    public void execute(String[] args, Console console) {
        block20: {
            block18: {
                String subCommand;
                if (args.length <= 0) break block18;
                switch (subCommand = args[0]) {
                    case "say": {
                        if (args.length > 1) {
                            this.say((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), console);
                        } else {
                            console.println("Specify text to say (e.g. 'say hello')");
                        }
                        return;
                    }
                    case "interpret": {
                        if (args.length > 1) {
                            this.interpret((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), console);
                        } else {
                            console.println("Specify text to interpret (e.g. 'interpret turn all lights off')");
                        }
                        return;
                    }
                    case "voices": {
                        for (Voice voice : this.voiceManager.getAllVoices()) {
                            console.println(String.valueOf(voice.getUID()) + " " + voice.getLabel() + " - " + voice.getLocale().getDisplayName());
                        }
                        return;
                    }
                }
                break block20;
            }
            this.printUsage(console);
        }
    }

    private void interpret(String[] args, Console console) {
        StringBuilder sb = new StringBuilder(args[0]);
        int i = 1;
        while (i < args.length) {
            sb.append(" ");
            sb.append(args[i]);
            ++i;
        }
        String msg = sb.toString();
        try {
            String result = this.voiceManager.interpret(msg);
            if (result != null) {
                console.println(result);
            }
        }
        catch (InterpretationException ie) {
            console.println(ie.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void say(String[] args, Console console) {
        msg = new StringBuilder();
        var7_4 = args;
        var6_5 = args.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block6: {
                word = var7_4[var5_6];
                if (word.startsWith("%") && word.endsWith("%") && word.length() > 2) {
                    itemName = word.substring(1, word.length() - 1);
                    try {
                        item = this.itemRegistry.getItemByPattern(itemName);
                        msg.append(item.getState().toString());
                        break block6;
                    }
                    catch (ItemNotFoundException e) {
                        console.println("Error: Item '" + itemName + "' does not exist.");
                        break block6;
                    }
                    catch (ItemNotUniqueException e) {
                        console.print("Error: Multiple items match this pattern: ");
                        ** for (item : e.getMatchingItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        console.print(String.valueOf(item.getName()) + " ");
                        continue;
lbl22:
                        // 1 sources

                        break block6;
                    }
                }
                msg.append(word);
            }
            msg.append(" ");
            ++var5_6;
        }
        this.voiceManager.say(msg.toString());
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void setVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = voiceManager;
    }

    protected void unsetVoiceManager(VoiceManager voiceManager) {
        this.voiceManager = null;
    }
}

