/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.voice.internal.text;

import java.util.Locale;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.NextPreviousType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.RewindFastforwardType;
import org.eclipse.smarthome.core.library.types.StopMoveType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.voice.text.AbstractRuleBasedInterpreter;
import org.eclipse.smarthome.core.voice.text.ExpressionAlternatives;
import org.eclipse.smarthome.core.voice.text.ExpressionCardinality;

public class StandardInterpreter
extends AbstractRuleBasedInterpreter {
    @Override
    public void createRules() {
        ExpressionAlternatives onOff = this.alt(this.cmd("on", (Command)OnOffType.ON), this.cmd("off", (Command)OnOffType.OFF));
        ExpressionAlternatives turn = this.alt("turn", "switch");
        ExpressionAlternatives put = this.alt("put", "bring");
        ExpressionCardinality of = this.opt("of");
        ExpressionCardinality the = this.opt("the");
        ExpressionCardinality to = this.opt("to");
        ExpressionAlternatives color = this.alt(this.cmd("white", (Command)HSBType.WHITE), this.cmd("pink", (Command)HSBType.fromRGB((int)255, (int)96, (int)208)), this.cmd("yellow", (Command)HSBType.fromRGB((int)255, (int)224, (int)32)), this.cmd("orange", (Command)HSBType.fromRGB((int)255, (int)160, (int)16)), this.cmd("purple", (Command)HSBType.fromRGB((int)128, (int)0, (int)128)), this.cmd("red", (Command)HSBType.RED), this.cmd("green", (Command)HSBType.GREEN), this.cmd("blue", (Command)HSBType.BLUE));
        this.addRules(Locale.ENGLISH, this.itemRule(this.seq(turn, the), onOff), this.itemRule(this.seq(turn, onOff)), this.itemRule(this.seq(this.cmd(this.alt("dim", "decrease", "lower", "soften"), (Command)IncreaseDecreaseType.DECREASE), the)), this.itemRule(this.seq(this.cmd(this.alt("brighten", "increase", "harden", "enhance"), (Command)IncreaseDecreaseType.INCREASE), the)), this.itemRule(this.seq(this.opt("set"), the, this.opt("color"), of, the), this.seq(to, color)), this.itemRule(this.seq(put, the), this.cmd("up", (Command)UpDownType.UP)), this.itemRule(this.seq(put, the), this.cmd("down", (Command)UpDownType.DOWN)), this.itemRule("move", this.seq(this.opt("to"), this.alt(this.cmd("next", (Command)NextPreviousType.NEXT), this.cmd("previous", (Command)NextPreviousType.PREVIOUS)))), this.itemRule(this.seq(this.cmd("play", (Command)PlayPauseType.PLAY), the)), this.itemRule(this.seq(this.cmd("pause", (Command)PlayPauseType.PAUSE), the)), this.itemRule(this.seq(this.cmd("rewind", (Command)RewindFastforwardType.REWIND), the)), this.itemRule(this.seq(this.cmd(this.seq(this.opt("fast"), "forward"), (Command)RewindFastforwardType.FASTFORWARD), the)), this.itemRule(this.seq(this.cmd("stop", (Command)StopMoveType.STOP), the)), this.itemRule(this.seq(this.cmd(this.alt("start", "move", "continue"), (Command)StopMoveType.MOVE), the)), this.itemRule(this.seq(this.cmd("refresh", (Command)RefreshType.REFRESH), the)));
        ExpressionAlternatives einAnAus = this.alt(this.cmd("ein", (Command)OnOffType.ON), this.cmd("an", (Command)OnOffType.ON), this.cmd("aus", (Command)OnOffType.OFF));
        ExpressionCardinality denDieDas = this.opt(this.alt("den", "die", "das"));
        ExpressionAlternatives schalte = this.alt("schalt", "schalte", "mach");
        ExpressionAlternatives pause = this.alt("pause", "stoppe");
        ExpressionAlternatives mache = this.alt("mach", "mache", "fahre");
        ExpressionAlternatives spiele = this.alt("spiele", "spiel", "starte");
        ExpressionAlternatives zu = this.alt("zu", "zum", "zur");
        ExpressionAlternatives naechste = this.alt("n\u00e4chste", "n\u00e4chstes", "n\u00e4chster");
        ExpressionAlternatives vorherige = this.alt("vorherige", "vorheriges", "vorheriger");
        ExpressionAlternatives farbe = this.alt(this.cmd("wei\u00df", (Command)HSBType.WHITE), this.cmd("pink", (Command)HSBType.fromRGB((int)255, (int)96, (int)208)), this.cmd("gelb", (Command)HSBType.fromRGB((int)255, (int)224, (int)32)), this.cmd("orange", (Command)HSBType.fromRGB((int)255, (int)160, (int)16)), this.cmd("lila", (Command)HSBType.fromRGB((int)128, (int)0, (int)128)), this.cmd("rot", (Command)HSBType.RED), this.cmd("gr\u00fcn", (Command)HSBType.GREEN), this.cmd("blau", (Command)HSBType.BLUE));
        this.addRules(Locale.GERMAN, this.itemRule(this.seq(schalte, denDieDas), einAnAus), this.itemRule(this.seq(this.cmd(this.alt("dimme"), (Command)IncreaseDecreaseType.DECREASE), denDieDas)), this.itemRule(this.seq(schalte, denDieDas), this.cmd(this.alt("dunkler", "weniger"), (Command)IncreaseDecreaseType.DECREASE)), this.itemRule(this.seq(schalte, denDieDas), this.cmd(this.alt("heller", "mehr"), (Command)IncreaseDecreaseType.INCREASE)), this.itemRule(this.seq(schalte, denDieDas), this.seq(this.opt("auf"), farbe)), this.itemRule(this.seq(mache, denDieDas), this.cmd("hoch", (Command)UpDownType.UP)), this.itemRule(this.seq(mache, denDieDas), this.cmd("runter", (Command)UpDownType.DOWN)), this.itemRule("wechsle", this.seq(this.opt(zu), this.alt(this.cmd(naechste, (Command)NextPreviousType.NEXT), this.cmd(vorherige, (Command)NextPreviousType.PREVIOUS)))), this.itemRule(this.seq(this.cmd(spiele, (Command)PlayPauseType.PLAY), the)), this.itemRule(this.seq(this.cmd(pause, (Command)PlayPauseType.PAUSE), the)));
        ExpressionAlternatives allumer = this.alt("allumer", "d\u00e9marrer", "activer");
        ExpressionAlternatives eteindre = this.alt("\u00e9teindre", "stopper", "d\u00e9sactiver", "couper");
        ExpressionCardinality lela = this.opt(this.alt("le", "la", "les", "l"));
        ExpressionCardinality poursurdude = this.opt(this.alt("pour", "sur", "du", "de"));
        ExpressionAlternatives couleur = this.alt(this.cmd("blanc", (Command)HSBType.WHITE), this.cmd("rose", (Command)HSBType.fromRGB((int)255, (int)96, (int)208)), this.cmd("jaune", (Command)HSBType.fromRGB((int)255, (int)224, (int)32)), this.cmd("orange", (Command)HSBType.fromRGB((int)255, (int)160, (int)16)), this.cmd("violet", (Command)HSBType.fromRGB((int)128, (int)0, (int)128)), this.cmd("rouge", (Command)HSBType.RED), this.cmd("vert", (Command)HSBType.GREEN), this.cmd("bleu", (Command)HSBType.BLUE));
        this.addRules(Locale.FRENCH, this.itemRule(this.seq(this.cmd(allumer, (Command)OnOffType.ON), lela)), this.itemRule(this.seq(this.cmd(eteindre, (Command)OnOffType.OFF), lela)), this.itemRule(this.seq(this.cmd("augmenter", (Command)IncreaseDecreaseType.INCREASE), lela)), this.itemRule(this.seq(this.cmd("diminuer", (Command)IncreaseDecreaseType.DECREASE), lela)), this.itemRule(this.seq(this.cmd("plus", (Command)IncreaseDecreaseType.INCREASE), "de")), this.itemRule(this.seq(this.cmd("moins", (Command)IncreaseDecreaseType.DECREASE), "de")), this.itemRule(this.seq("couleur", couleur, this.opt("pour"), lela)), this.itemRule(this.seq(this.cmd("reprise", (Command)PlayPauseType.PLAY), "lecture", poursurdude, lela)), this.itemRule(this.seq(this.cmd("pause", (Command)PlayPauseType.PAUSE), "lecture", poursurdude, lela)), this.itemRule(this.seq(this.alt("plage", "piste"), this.alt(this.cmd("suivante", (Command)NextPreviousType.NEXT), this.cmd("pr\u00e9c\u00e9dente", (Command)NextPreviousType.PREVIOUS)), poursurdude, lela)), this.itemRule(this.seq(this.cmd("monter", (Command)UpDownType.UP), lela)), this.itemRule(this.seq(this.cmd("descendre", (Command)UpDownType.DOWN), lela)), this.itemRule(this.seq(this.cmd("arr\u00eater", (Command)StopMoveType.STOP), lela)), this.itemRule(this.seq(this.cmd(this.alt("bouger", "d\u00e9placer"), (Command)StopMoveType.MOVE), lela)), this.itemRule(this.seq(this.cmd("rafra\u00eechir", (Command)RefreshType.REFRESH), lela)));
    }

    @Override
    public String getId() {
        return "system";
    }

    @Override
    public String getLabel(Locale locale) {
        return "Built-in Interpreter";
    }
}

