/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.jsonpath.internal;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSonPathTransformationService
implements TransformationService {
    private final Logger logger = LoggerFactory.getLogger(JSonPathTransformationService.class);

    public String transform(String jsonPathExpression, String source) throws TransformationException {
        if (jsonPathExpression == null || source == null) {
            throw new TransformationException("the given parameters 'JSonPath' and 'source' must not be null");
        }
        this.logger.debug("about to transform '{}' by the function '{}'", (Object)source, (Object)jsonPathExpression);
        try {
            Object transformationResult = JsonPath.read((String)source, (String)jsonPathExpression, (Predicate[])new Predicate[0]);
            this.logger.debug("transformation resulted in '{}'", transformationResult);
            return transformationResult != null ? transformationResult.toString() : source;
        }
        catch (PathNotFoundException e) {
            throw new TransformationException("Invalid path '" + jsonPathExpression + "' in '" + source + "'");
        }
        catch (InvalidJsonException | InvalidPathException e) {
            throw new TransformationException("An error occurred while transforming JSON expression.", e);
        }
    }
}

