/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.ConfigurationException;
import javax.net.SocketFactory;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionState;
import org.eclipse.smarthome.io.transport.mqtt.MqttException;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageProducer;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageSubscriber;
import org.eclipse.smarthome.io.transport.mqtt.MqttPublishCallback;
import org.eclipse.smarthome.io.transport.mqtt.MqttPublishResult;
import org.eclipse.smarthome.io.transport.mqtt.MqttWillAndTestament;
import org.eclipse.smarthome.io.transport.mqtt.internal.MqttSenderChannelImpl;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.AbstractReconnectStrategy;
import org.eclipse.smarthome.io.transport.mqtt.reconnect.PeriodicReconnectStrategy;
import org.eclipse.smarthome.io.transport.mqtt.sslcontext.AcceptAllCertificatesSSLContext;
import org.eclipse.smarthome.io.transport.mqtt.sslcontext.SSLContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttBrokerConnection {
    private final Logger logger = LoggerFactory.getLogger(MqttBrokerConnection.class);
    public static final int DEFAULT_KEEPALIVE_INTERVAL = 60;
    public static final int DEFAULT_QOS = 0;
    private final boolean textualConfiguredBroker;
    private final String name;
    private final String url;
    private String user;
    private String password;
    private int qos = 0;
    private boolean retain = false;
    private MqttWillAndTestament lastWill;
    private AbstractReconnectStrategy reconnectStrategy;
    private SSLContextProvider sslContextProvider = new AcceptAllCertificatesSSLContext();
    private int keepAliveInterval = 60;
    private String clientId;
    private MqttAsyncClient client;
    private boolean isConnecting = false;
    private final List<MqttConnectionObserver> connectionObservers = new CopyOnWriteArrayList<MqttConnectionObserver>();
    private final Map<String, List<MqttMessageSubscriber>> consumers = new HashMap<String, List<MqttMessageSubscriber>>();
    @Deprecated
    private final List<MqttMessageProducer> producers = new CopyOnWriteArrayList<MqttMessageProducer>();
    private ClientCallbacks clientCallbacks = new ClientCallbacks();

    public MqttBrokerConnection(@NonNull String name, @NonNull String url, boolean textualConfiguredBroker) throws ConfigurationException {
        this.textualConfiguredBroker = textualConfiguredBroker;
        if (name.isEmpty()) {
            throw new ConfigurationException("No name for the broker set!");
        }
        if (url.isEmpty() || !url.startsWith("tcp://") && !url.startsWith("ssl://")) {
            throw new ConfigurationException("No valid url for the broker set! Must be tcp://localhost:1234 or ssl://localhost:1234. Port is optional.");
        }
        this.name = name;
        this.url = url;
        this.setReconnectStrategy(new PeriodicReconnectStrategy());
    }

    public void setReconnectStrategy(AbstractReconnectStrategy reconnectStrategy) {
        this.reconnectStrategy = reconnectStrategy;
        reconnectStrategy.setBrokerConnection(this);
    }

    public AbstractReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isTextualConfiguredBroker() {
        return this.textualConfiguredBroker;
    }

    public void setCredentials(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        if (qos >= 0 && qos <= 2) {
            this.qos = qos;
        }
    }

    public boolean isRetain() {
        return this.retain;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    public MqttWillAndTestament getLastWill() {
        return this.lastWill;
    }

    public void setLastWill(MqttWillAndTestament lastWill) {
        this.lastWill = lastWill;
    }

    public void setClientId(String value) {
        if (value != null && value.length() > 23) {
            return;
        }
        this.clientId = value;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        if (keepAliveInterval <= 0) {
            return;
        }
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public SSLContextProvider getSSLContextProvider() {
        return this.sslContextProvider;
    }

    public void setSSLContextProvider(SSLContextProvider sslContextProvider) {
        this.sslContextProvider = sslContextProvider;
    }

    public boolean hasConsumers() {
        return !this.consumers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConsumer(MqttMessageSubscriber subscriber) throws MqttException {
        String topic = StringUtils.replace((String)StringUtils.replace((String)subscriber.getTopic(), (String)"+", (String)"[^/]*"), (String)"#", (String)".*");
        Map<String, List<MqttMessageSubscriber>> map = this.consumers;
        synchronized (map) {
            List<MqttMessageSubscriber> subscriberList = this.consumers.get(topic);
            if (subscriberList == null) {
                subscriberList = new ArrayList<MqttMessageSubscriber>();
            }
            subscriberList.add(subscriber);
            this.consumers.put(topic, subscriberList);
        }
        if (this.isConnected()) {
            try {
                this.client.subscribe(subscriber.getTopic(), this.qos);
            }
            catch (org.eclipse.paho.client.mqttv3.MqttException e) {
                throw new MqttException(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(MqttMessageSubscriber subscriber) {
        this.logger.trace("Unsubscribing message consumer for topic '{}' from broker '{}'", (Object)subscriber.getTopic(), (Object)this.getName());
        try {
            if (this.isConnected()) {
                this.client.unsubscribe(subscriber.getTopic());
            }
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            this.logger.info("Error unsubscribing topic from broker", (Throwable)e);
        }
        Map<String, List<MqttMessageSubscriber>> map = this.consumers;
        synchronized (map) {
            List<MqttMessageSubscriber> list = this.consumers.get(subscriber.getTopic());
            if (list != null) {
                list.remove(subscriber);
                if (list.isEmpty()) {
                    this.consumers.remove(subscriber.getTopic());
                }
            }
        }
    }

    public synchronized void addConnectionObserver(MqttConnectionObserver connectionObserver) {
        this.connectionObservers.add(connectionObserver);
    }

    public synchronized void removeConnectionObserver(MqttConnectionObserver connectionObserver) {
        this.connectionObservers.remove(connectionObserver);
    }

    public boolean hasConnectionObservers() {
        return !this.connectionObservers.isEmpty();
    }

    @Deprecated
    public synchronized void addProducer(MqttMessageProducer publisher) {
        this.producers.add(publisher);
        if (this.isConnected()) {
            publisher.setSenderChannel(new MqttSenderChannelImpl(this));
        }
    }

    @Deprecated
    public synchronized void removeProducer(MqttMessageProducer publisher) {
        publisher.setSenderChannel(null);
        this.producers.remove(publisher);
    }

    MqttConnectOptions createMqttOptions() throws ConfigurationException {
        MqttConnectOptions options = new MqttConnectOptions();
        if (!StringUtils.isBlank((String)this.user)) {
            options.setUserName(this.user);
        }
        if (!StringUtils.isBlank((String)this.password)) {
            options.setPassword(this.password.toCharArray());
        }
        if (this.getUrl().toLowerCase().startsWith("ssl")) {
            options.setSocketFactory((SocketFactory)this.sslContextProvider.getContext().getSocketFactory());
        }
        if (this.lastWill != null) {
            options.setWill(this.lastWill.getTopic(), this.lastWill.getPayload(), this.lastWill.getQos(), this.lastWill.isRetain());
        }
        options.setKeepAliveInterval(this.keepAliveInterval);
        return options;
    }

    IMqttActionListener createConnectionListener() {
        return new IMqttActionListener(){

            public void onSuccess(IMqttToken asyncActionToken) {
                MqttBrokerConnection.this.isConnecting = false;
                MqttBrokerConnection.this.reconnectStrategy.connectionEstablished();
                for (List consumerList : MqttBrokerConnection.this.consumers.values()) {
                    for (MqttMessageSubscriber c : consumerList) {
                        try {
                            MqttBrokerConnection.this.client.subscribe(c.getTopic(), MqttBrokerConnection.this.qos);
                        }
                        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
                            MqttBrokerConnection.this.logger.debug("Couldn't start subscriber", (Throwable)e);
                        }
                    }
                }
                for (MqttMessageProducer p : MqttBrokerConnection.this.producers) {
                    p.setSenderChannel(new MqttSenderChannelImpl(MqttBrokerConnection.this));
                }
                for (MqttConnectionObserver connectionObserver : MqttBrokerConnection.this.connectionObservers) {
                    connectionObserver.connectionStateChanged(MqttBrokerConnection.this.isConnected() ? MqttConnectionState.CONNECTED : MqttConnectionState.DISCONNECTED, null);
                }
            }

            public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                for (MqttConnectionObserver connectionObserver : MqttBrokerConnection.this.connectionObservers) {
                    connectionObserver.connectionStateChanged(MqttBrokerConnection.this.isConnected() ? MqttConnectionState.CONNECTED : MqttConnectionState.DISCONNECTED, asyncActionToken.getException());
                }
                if (MqttBrokerConnection.this.isConnecting) {
                    MqttBrokerConnection.this.isConnecting = false;
                    MqttBrokerConnection.this.reconnectStrategy.lostConnection();
                }
            }
        };
    }

    public synchronized void start() throws MqttException, ConfigurationException {
        if (this.isConnecting || this.isConnected()) {
            return;
        }
        if (this.reconnectStrategy != null) {
            this.reconnectStrategy.start();
        }
        if (StringUtils.isBlank((String)this.clientId) || this.clientId.length() > 23) {
            this.clientId = MqttClient.generateClientId();
        }
        String tmpDir = String.valueOf(System.getProperty("java.io.tmpdir")) + "/" + this.getName();
        MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(tmpDir);
        try {
            this.client = new MqttAsyncClient(this.getUrl(), this.clientId, (MqttClientPersistence)dataStore);
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e);
        }
        this.client.setCallback((MqttCallback)this.clientCallbacks);
        this.logger.info("Starting MQTT broker connection '{}' to '{}' with clientid {} and file store '{}'", new Object[]{this.getName(), this.getUrl(), this.getClientId(), tmpDir});
        this.isConnecting = true;
        try {
            this.client.connect(this.createMqttOptions(), null, this.createConnectionListener());
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e);
        }
    }

    public synchronized void close() {
        this.logger.trace("Closing the MQTT broker connection '{}'", (Object)this.getName());
        this.isConnecting = false;
        if (this.reconnectStrategy != null) {
            this.reconnectStrategy.stop();
        }
        try {
            if (this.isConnected()) {
                this.client.disconnect();
                this.client = null;
            }
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            this.logger.info("Error closing connection to broker", (Throwable)e);
        }
        for (MqttConnectionObserver connectionObserver : this.connectionObservers) {
            connectionObserver.connectionStateChanged(MqttConnectionState.DISCONNECTED, null);
        }
    }

    public int publish(final String topic, byte[] payload, final MqttPublishCallback listener) throws MqttException {
        IMqttDeliveryToken deliveryToken;
        try {
            deliveryToken = this.client.publish(topic, payload, this.qos, this.retain, null, new IMqttActionListener(){

                public void onSuccess(IMqttToken token) {
                    listener.onSuccess(new MqttPublishResult(token.getMessageId(), topic));
                }

                public void onFailure(IMqttToken token, Throwable error) {
                    listener.onFailure(new MqttPublishResult(token.getMessageId(), topic), error);
                }
            });
        }
        catch (org.eclipse.paho.client.mqttv3.MqttException e) {
            throw new MqttException(e);
        }
        this.logger.debug("Publishing message {} to topic '{}'", (Object)deliveryToken.getMessageId(), (Object)topic);
        return deliveryToken.getMessageId();
    }

    private class ClientCallbacks
    implements MqttCallback {
        private ClientCallbacks() {
        }

        public synchronized void connectionLost(Throwable t) {
            if (t instanceof MqttException) {
                MqttException e = (MqttException)t;
                MqttBrokerConnection.this.logger.info("MQTT connection to '{}' was lost: {} : ReasonCode {} : Cause : {}", new Object[]{MqttBrokerConnection.this.getName(), e.getMessage(), e.getReasonCode(), e.getCause() == null ? "Unknown" : e.getCause().getMessage()});
            } else {
                MqttBrokerConnection.this.logger.info("MQTT connection to '{}' was lost: {}", (Object)MqttBrokerConnection.this.getName(), (Object)t.getMessage());
            }
            for (MqttConnectionObserver connectionObserver : MqttBrokerConnection.this.connectionObservers) {
                connectionObserver.connectionStateChanged(MqttConnectionState.DISCONNECTED, t);
            }
            MqttBrokerConnection.this.reconnectStrategy.lostConnection();
        }

        public void deliveryComplete(IMqttDeliveryToken token) {
            MqttBrokerConnection.this.logger.trace("Message with id {} delivered.", (Object)token.getMessageId());
        }

        public void messageArrived(String topic, MqttMessage message) {
            MqttBrokerConnection.this.logger.trace("Received message on topic '{}' : {}", (Object)topic, (Object)new String(message.getPayload()));
            for (Map.Entry entry : MqttBrokerConnection.this.consumers.entrySet()) {
                String target = (String)entry.getKey();
                List consumerList = (List)entry.getValue();
                if (topic.matches(target)) {
                    MqttBrokerConnection.this.logger.trace("Topic match for '{}' and '{}' using regex {}", (Object)topic, (Object)target);
                    for (MqttMessageSubscriber consumer : consumerList) {
                        consumer.processMessage(topic, message.getPayload());
                    }
                    continue;
                }
                MqttBrokerConnection.this.logger.trace("No topic match for '{}' and '{}' using regex {}", (Object)topic, (Object)target);
            }
        }
    }
}

