/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mqtt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokerConnection;
import org.eclipse.smarthome.io.transport.mqtt.MqttBrokersObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttConnectionObserver;
import org.eclipse.smarthome.io.transport.mqtt.MqttException;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageConsumer;
import org.eclipse.smarthome.io.transport.mqtt.MqttMessageProducer;
import org.eclipse.smarthome.io.transport.mqtt.MqttWillAndTestament;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={MqttService.class}, configurationPid="org.eclipse.smarthome.mqtt", property={"service.pid=org.eclipse.smarthome.mqtt"})
@NonNullByDefault
public class MqttService {
    private static final String NAME_PROPERTY = "name";
    private final Logger logger = LoggerFactory.getLogger(MqttService.class);
    private final Map<String, MqttBrokerConnection> brokerConnections = new ConcurrentHashMap<String, MqttBrokerConnection>();
    private final List<MqttBrokersObserver> brokersObservers = new CopyOnWriteArrayList<MqttBrokersObserver>();
    @Deprecated
    private @Nullable EventPublisher eventPublisher;

    public Map<String, Map<String, String>> extractBrokerConfigurations(Map<String, Object> properties) {
        HashMap<String, Map<String, String>> configPerBroker = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (key.equals("service.pid") || key.equals("objectClass") || key.equals("component.name") || key.equals("component.id")) continue;
            if (!(entry.getValue() instanceof String)) {
                this.logger.warn("Unexpected value in broker configuration {}:{}", (Object)entry.getKey(), entry.getValue());
                continue;
            }
            String value = (String)entry.getValue();
            String[] subkeys = key.split("\\.");
            if (subkeys.length != 2 || StringUtils.isBlank((String)value)) {
                this.logger.debug("MQTT Broker property '{}={}' should have the format 'broker.propertykey=value'", (Object)key, (Object)value);
                continue;
            }
            String brokername = subkeys[0].toLowerCase();
            HashMap<String, String> brokerConfig = (HashMap<String, String>)configPerBroker.get(brokername);
            if (brokerConfig == null) {
                brokerConfig = new HashMap<String, String>();
                configPerBroker.put(brokername, brokerConfig);
                brokerConfig.put(NAME_PROPERTY, brokername);
            }
            brokerConfig.put(subkeys[1], value);
        }
        return configPerBroker;
    }

    @Modified
    public void modified(Map<String, Object> config) {
        Iterator<Map.Entry<String, MqttBrokerConnection>> it = this.brokerConnections.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MqttBrokerConnection> entry = it.next();
            MqttBrokerConnection connection = entry.getValue();
            if (!connection.isTextualConfiguredBroker()) continue;
            this.logger.debug("Received new Mqtt configuration: Close connection to {}:{}", (Object)connection.getName(), (Object)connection.getClientId());
            connection.close();
            it.remove();
        }
        if (config == null || config.isEmpty()) {
            return;
        }
        Map<String, Map<String, String>> brokerConfigs = this.extractBrokerConfigurations(config);
        for (Map<String, String> brokerConfig : brokerConfigs.values()) {
            try {
                MqttBrokerConnection conn = this.addBrokerConnection(brokerConfig);
                if (conn == null) {
                    this.logger.warn("MqttBroker connection name already present.");
                    continue;
                }
                conn.start();
            }
            catch (ConfigurationException e) {
                this.logger.warn("MqttBroker connection configuration faulty: {}", (Object)e.getMessage());
            }
            catch (MqttException e) {
                this.logger.warn("MqttBroker start failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Activate
    public void activate(Map<String, Object> config) {
        this.logger.debug("Starting MQTT Service...");
        this.modified(config);
    }

    @Deactivate
    public void deactivate() {
        this.logger.debug("Stopping MQTT Service...");
        for (MqttBrokerConnection conn : this.brokerConnections.values()) {
            conn.close();
        }
        this.brokerConnections.clear();
    }

    public void addBrokersListener(MqttBrokersObserver observer) {
        this.brokersObservers.add(observer);
    }

    public void removeBrokersListener(MqttBrokersObserver observer) {
        this.brokersObservers.remove(observer);
    }

    public boolean hasBrokerObservers() {
        return !this.brokersObservers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable MqttBrokerConnection getBrokerConnection(String brokerName) {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            return this.brokerConnections.get(brokerName.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBrokerConnection(MqttBrokerConnection connection) {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            String brokerID;
            block5: {
                brokerID = connection.getName().toLowerCase();
                if (!this.brokerConnections.containsKey(brokerID)) break block5;
                return false;
            }
            this.brokerConnections.put(brokerID, connection);
            for (MqttBrokersObserver o : this.brokersObservers) {
                o.brokerAdded(connection);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable MqttBrokerConnection addBrokerConnection(Map<String, String> brokerConnectionConfig) throws ConfigurationException, MqttException {
        MqttWillAndTestament will;
        MqttBrokerConnection connection;
        String brokerID = brokerConnectionConfig.get(NAME_PROPERTY);
        if (brokerID == null || brokerID.isEmpty()) {
            throw new ConfigurationException("MQTT Broker property 'name' is not provided");
        }
        brokerID = brokerID.toLowerCase();
        String brokerURL = brokerConnectionConfig.get("url");
        if (brokerURL == null || brokerURL.isEmpty()) {
            throw new ConfigurationException("MQTT Broker property 'url' is not provided");
        }
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            block11: {
                connection = this.brokerConnections.get(brokerID);
                if (connection == null) break block11;
                return null;
            }
            connection = new MqttBrokerConnection(brokerID, brokerURL, true);
            this.brokerConnections.put(brokerID, connection);
        }
        connection.setCredentials(brokerConnectionConfig.get("user"), brokerConnectionConfig.get("pwd"));
        connection.setClientId(brokerConnectionConfig.get("clientId"));
        String property = brokerConnectionConfig.get("keepAlive");
        if (!StringUtils.isBlank((String)property)) {
            connection.setKeepAliveInterval(Integer.valueOf(property));
        }
        if (!StringUtils.isBlank((String)(property = brokerConnectionConfig.get("qos")))) {
            connection.setQos(Integer.valueOf(property));
        }
        if (!StringUtils.isBlank((String)(property = brokerConnectionConfig.get("retain")))) {
            connection.setRetain(Boolean.valueOf(property));
        }
        if ((will = MqttWillAndTestament.fromString(brokerConnectionConfig.get("lwt"))) != null) {
            this.logger.debug("Setting last will: {}", (Object)will);
            connection.setLastWill(will);
        }
        for (MqttBrokersObserver o : this.brokersObservers) {
            o.brokerAdded(connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBrokerConnection(MqttBrokerConnection connection) {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            if (this.brokerConnections.remove(connection.getName().toLowerCase(), connection)) {
                for (MqttBrokersObserver o : this.brokersObservers) {
                    o.brokerRemoved(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable MqttBrokerConnection removeBrokerConnection(String brokerName) {
        Map<String, MqttBrokerConnection> map = this.brokerConnections;
        synchronized (map) {
            MqttBrokerConnection connection = this.brokerConnections.remove(brokerName.toLowerCase());
            if (connection != null) {
                for (MqttBrokersObserver o : this.brokersObservers) {
                    o.brokerRemoved(connection);
                }
            }
            return connection;
        }
    }

    public Collection<MqttBrokerConnection> getAllBrokerConnections() {
        return this.brokerConnections.values();
    }

    @Deprecated
    public void registerConnectionObserver(String brokerName, MqttConnectionObserver connectionObserver) {
        MqttBrokerConnection brokerConnection = this.getBrokerConnection(brokerName);
        if (brokerConnection != null) {
            brokerConnection.addConnectionObserver(connectionObserver);
        }
    }

    @Deprecated
    public void unregisterConnectionObserver(String brokerName, MqttConnectionObserver connectionObserver) {
        MqttBrokerConnection brokerConnection = this.getBrokerConnection(brokerName);
        if (brokerConnection != null) {
            brokerConnection.removeConnectionObserver(connectionObserver);
        }
    }

    @Deprecated
    public void registerMessageConsumer(String brokerName, MqttMessageConsumer mqttMessageConsumer) {
        try {
            MqttBrokerConnection brokerConnection = this.getBrokerConnection(brokerName);
            if (brokerConnection != null) {
                brokerConnection.addConsumer(mqttMessageConsumer);
                mqttMessageConsumer.setEventPublisher(this.eventPublisher);
            }
        }
        catch (MqttException e) {
            this.logger.debug("Consumer could not be activated", (Throwable)e);
        }
    }

    @Deprecated
    public void unregisterMessageConsumer(String brokerName, MqttMessageConsumer mqttMessageConsumer) {
        MqttBrokerConnection brokerConnection = this.getBrokerConnection(brokerName);
        if (brokerConnection != null) {
            brokerConnection.removeConsumer(mqttMessageConsumer);
        }
    }

    @Deprecated
    public void registerMessageProducer(String brokerName, MqttMessageProducer commandPublisher) {
        MqttBrokerConnection brokerConnection = this.getBrokerConnection(brokerName);
        if (brokerConnection != null) {
            brokerConnection.addProducer(commandPublisher);
        }
    }

    @Deprecated
    public void unregisterMessageProducer(String brokerName, MqttMessageProducer commandPublisher) {
        MqttBrokerConnection brokerConnection = this.getBrokerConnection(brokerName);
        if (brokerConnection != null) {
            brokerConnection.removeProducer(commandPublisher);
        }
    }

    @Deprecated
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Deprecated
    public void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

