/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusDetail;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.StatusInfoCallback;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.Connection;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.core.internal.RuleEngineCallbackImpl;
import org.eclipse.smarthome.automation.core.internal.RuntimeAction;
import org.eclipse.smarthome.automation.core.internal.RuntimeCondition;
import org.eclipse.smarthome.automation.core.internal.RuntimeRule;
import org.eclipse.smarthome.automation.core.internal.RuntimeTrigger;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeModuleHandlerFactory;
import org.eclipse.smarthome.automation.core.util.ConnectionValidator;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngine
implements RegistryChangeListener<ModuleType> {
    public static final char OUTPUT_SEPARATOR = '.';
    public static final long DEFAULT_REINITIALIZATION_DELAY = 500L;
    public static final String CONFIG_PROPERTY_REINITIALIZATION_DELAY = "rule.reinitialization.delay";
    private long scheduleReinitializationDelay;
    private final Map<String, RuleEngineCallbackImpl> reCallbacks = new HashMap<String, RuleEngineCallbackImpl>();
    private final Map<String, Set<String>> mapModuleTypeToRules = new HashMap<String, Set<String>>();
    private final Map<String, RuntimeRule> rules;
    private final Map<String, ModuleHandlerFactory> moduleHandlerFactories;
    private final Set<ModuleHandlerFactory> allModuleHandlerFactories = new CopyOnWriteArraySet<ModuleHandlerFactory>();
    private boolean isDisposed = false;
    private final Map<String, RuleStatusInfo> statusMap = new HashMap<String, RuleStatusInfo>();
    protected Logger logger = LoggerFactory.getLogger((String)RuleEngine.class.getName());
    private StatusInfoCallback statusInfoCallback;
    private Map<String, Map<String, Object>> contextMap;
    private ModuleTypeRegistry mtRegistry;
    private CompositeModuleHandlerFactory compositeFactory;
    private Map<String, Future> scheduleTasks = new HashMap<String, Future>(31);
    private ScheduledExecutorService executor;
    private Gson gson;

    public RuleEngine() {
        this.rules = new HashMap<String, RuntimeRule>(20);
        this.contextMap = new HashMap<String, Map<String, Object>>();
        this.moduleHandlerFactories = new HashMap<String, ModuleHandlerFactory>(20);
    }

    protected void setModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        if (moduleTypeRegistry == null) {
            this.mtRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
            this.mtRegistry = null;
        } else {
            this.mtRegistry = moduleTypeRegistry;
            this.mtRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        }
        ConnectionValidator.setRegistry(this.mtRegistry);
    }

    protected void setCompositeModuleHandlerFactory(CompositeModuleHandlerFactory compositeFactory) {
        this.compositeFactory = compositeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(ModuleType moduleType) {
        String moduleTypeName = moduleType.getUID();
        for (ModuleHandlerFactory moduleHandlerFactory : this.allModuleHandlerFactories) {
            Collection moduleTypes = moduleHandlerFactory.getTypes();
            if (!moduleTypes.contains(moduleTypeName)) continue;
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                this.moduleHandlerFactories.put(moduleTypeName, moduleHandlerFactory);
                break;
            }
        }
        HashSet<String> rules = null;
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
            if (rulesPerModule != null) {
                rules = new HashSet<String>();
                rules.addAll(rulesPerModule);
            }
        }
        if (rules != null) {
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.UNINITIALIZED) continue;
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    public void removed(ModuleType moduleType) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(ModuleType oldElement, ModuleType moduleType) {
        if (moduleType.equals((Object)oldElement)) {
            return;
        }
        String moduleTypeName = moduleType.getUID();
        HashSet<String> rules = null;
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
            if (rulesPerModule != null) {
                rules = new HashSet<String>();
                rules.addAll(rulesPerModule);
            }
        }
        if (rules != null) {
            for (String rUID : rules) {
                if (this.getRuleStatus(rUID).equals((Object)RuleStatus.IDLE) || this.getRuleStatus(rUID).equals((Object)RuleStatus.RUNNING)) {
                    this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED), true);
                    this.unregister(this.getRuntimeRule(rUID));
                }
                if (this.getRuleStatus(rUID).equals((Object)RuleStatus.DISABLED)) continue;
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    protected void addModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        this.logger.debug("ModuleHandlerFactory added.");
        this.allModuleHandlerFactories.add(moduleHandlerFactory);
        Collection moduleTypes = moduleHandlerFactory.getTypes();
        this.addNewModuleTypes(moduleHandlerFactory, moduleTypes);
    }

    protected void removeModuleHandlerFactory(ModuleHandlerFactory moduleHandlerFactory) {
        if (moduleHandlerFactory instanceof CompositeModuleHandlerFactory) {
            this.compositeFactory.deactivate();
            this.compositeFactory = null;
        }
        this.allModuleHandlerFactories.remove(moduleHandlerFactory);
        Collection moduleTypes = moduleHandlerFactory.getTypes();
        this.removeMissingModuleTypes(moduleTypes);
        this.updateModuleHandlerFactoryMap(moduleTypes);
    }

    private synchronized void updateModuleHandlerFactoryMap(Collection<String> removedTypes) {
        for (String moduleTypeName : removedTypes) {
            this.moduleHandlerFactories.remove(moduleTypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRule(Rule rule, boolean isEnabled) {
        String rUID = rule.getUID();
        RuntimeRule runtimeRule = new RuntimeRule(rule);
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            this.rules.put(rUID, runtimeRule);
            if (isEnabled) {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED), false);
                this.setRule(runtimeRule);
            } else {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.DISABLED), true);
            }
        }
    }

    private void validateModuleIDs(List<Module> modules) {
        for (Module m : modules) {
            String mId = m.getId();
            if (mId != null && mId.matches("[A-Za-z0-9_-]*")) continue;
            throw new IllegalArgumentException("Invalid module uid: " + (mId != null ? mId : "null") + ". It must not be null or not fit to the pattern: [A-Za-z0-9_-]*");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRule(Rule rule, boolean isEnabled) {
        String rUID = rule.getUID();
        if (this.getRuntimeRule(rUID) == null) {
            this.logger.debug("There is no rule with UID '{}' which could be updated", (Object)rUID);
            return;
        }
        RuntimeRule runtimeRule = new RuntimeRule(rule);
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            RuntimeRule oldRule = this.rules.get(rUID);
            this.unregister(oldRule);
            this.rules.put(rUID, runtimeRule);
            if (isEnabled) {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED), false);
                this.setRule(runtimeRule);
            } else {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.DISABLED), true);
            }
        }
        this.logger.debug("Rule with UID '{}' is updated.", (Object)rUID);
    }

    private void setRule(RuntimeRule runtimeRule) {
        String errMsgs;
        if (this.isDisposed) {
            return;
        }
        String rUID = runtimeRule.getUID();
        this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.INITIALIZING), true);
        if (runtimeRule.getTemplateUID() != null) {
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.TEMPLATE_MISSING_ERROR), true);
            return;
        }
        List modules = runtimeRule.getModules(Module.class);
        for (Module m : modules) {
            this.updateMapModuleTypeToRule(rUID, m.getTypeUID());
        }
        try {
            this.validateModuleIDs(modules);
            this.resolveConfiguration(runtimeRule);
            this.autoMapConnections(runtimeRule);
            ConnectionValidator.validateConnections(runtimeRule);
        }
        catch (RuntimeException e) {
            errMsgs = "\n Validation of rule " + rUID + " has failed! " + e.getLocalizedMessage();
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.CONFIGURATION_ERROR, errMsgs.trim()), true);
            return;
        }
        errMsgs = this.setModuleHandlers(rUID, modules);
        if (errMsgs == null) {
            this.register(runtimeRule);
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.IDLE), true);
            Future f = this.scheduleTasks.remove(rUID);
            if (f != null && !f.isDone()) {
                f.cancel(true);
            }
            if (this.scheduleTasks.isEmpty() && this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        } else {
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.HANDLER_INITIALIZING_ERROR, errMsgs), true);
            this.unregister(runtimeRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRuleStatusInfo(String rUID, RuleStatusInfo status, boolean isSendEvent) {
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            this.statusMap.put(rUID, status);
        }
        if (isSendEvent) {
            this.notifyStatusInfoCallback(rUID, status);
        }
    }

    private void notifyStatusInfoCallback(String rUID, RuleStatusInfo statusInfo) {
        StatusInfoCallback statusInfoCallback = this.statusInfoCallback;
        if (statusInfoCallback != null) {
            try {
                statusInfoCallback.statusInfoChanged(rUID, statusInfo);
            }
            catch (Exception exc) {
                this.logger.error("Exception while notifying StatusInfoCallback '{}' for rule '{}'", new Object[]{statusInfoCallback, rUID, exc});
            }
        }
    }

    private <T extends Module> String setModuleHandlers(String rUID, List<T> modules) {
        StringBuffer sb = null;
        if (modules != null) {
            for (Module m : modules) {
                String message;
                try {
                    ModuleHandler moduleHandler = this.getModuleHandler(m, rUID);
                    if (moduleHandler != null) {
                        if (m instanceof RuntimeAction) {
                            ((RuntimeAction)m).setModuleHandler((ActionHandler)moduleHandler);
                            continue;
                        }
                        if (m instanceof RuntimeCondition) {
                            ((RuntimeCondition)m).setModuleHandler((ConditionHandler)moduleHandler);
                            continue;
                        }
                        if (!(m instanceof RuntimeTrigger)) continue;
                        ((RuntimeTrigger)m).setModuleHandler((TriggerHandler)moduleHandler);
                        continue;
                    }
                    if (sb == null) {
                        sb = new StringBuffer();
                    }
                    message = "Missing handler '" + m.getTypeUID() + "' for module '" + m.getId() + "'";
                    sb.append(message).append("\n");
                    this.logger.trace(message);
                }
                catch (Throwable t) {
                    if (sb == null) {
                        sb = new StringBuffer();
                    }
                    message = "Getting handler '" + m.getTypeUID() + "' for module '" + m.getId() + "' failed: " + t.getMessage();
                    sb.append(message).append("\n");
                    this.logger.trace(message);
                }
            }
        }
        return sb != null ? sb.toString() : null;
    }

    private synchronized RuleEngineCallbackImpl getRuleEngineCallback(RuntimeRule rule) {
        RuleEngineCallbackImpl result = this.reCallbacks.get(rule.getUID());
        if (result == null) {
            result = new RuleEngineCallbackImpl(this, rule);
            this.reCallbacks.put(rule.getUID(), result);
        }
        return result;
    }

    private <T extends Module> void removeModuleHandlers(List<T> modules, String ruleUID) {
        if (modules != null) {
            for (Module m : modules) {
                ActionHandler handler = null;
                if (m instanceof RuntimeAction) {
                    handler = ((RuntimeAction)m).getModuleHandler();
                } else if (m instanceof RuntimeCondition) {
                    handler = ((RuntimeCondition)m).getModuleHandler();
                } else if (m instanceof RuntimeTrigger) {
                    handler = ((RuntimeTrigger)m).getModuleHandler();
                }
                if (handler == null) continue;
                ModuleHandlerFactory factory = this.getModuleHandlerFactory(m.getTypeUID());
                if (factory != null) {
                    factory.ungetHandler(m, ruleUID, (ModuleHandler)handler);
                }
                if (m instanceof RuntimeAction) {
                    ((RuntimeAction)m).setModuleHandler(null);
                    continue;
                }
                if (m instanceof RuntimeCondition) {
                    ((RuntimeCondition)m).setModuleHandler(null);
                    continue;
                }
                if (!(m instanceof RuntimeTrigger)) continue;
                ((RuntimeTrigger)m).setModuleHandler(null);
            }
        }
    }

    private void register(RuntimeRule rule) {
        RuleEngineCallbackImpl reCallback = this.getRuleEngineCallback(rule);
        for (RuntimeTrigger t : rule.getTriggers()) {
            TriggerHandler triggerHandler = t.getModuleHandler();
            triggerHandler.setRuleEngineCallback((RuleEngineCallback)reCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(RuntimeRule r) {
        if (r != null) {
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                RuleEngineCallbackImpl reCallback = this.reCallbacks.remove(r.getUID());
                if (reCallback != null) {
                    reCallback.dispose();
                }
            }
            this.removeModuleHandlers(r.getTriggers(), r.getUID());
            this.removeModuleHandlers(r.getActions(), r.getUID());
            this.removeModuleHandlers(r.getConditions(), r.getUID());
        }
    }

    private ModuleHandler getModuleHandler(Module m, String ruleUID) {
        String moduleTypeId = m.getTypeUID();
        ModuleHandlerFactory mhf = this.getModuleHandlerFactory(moduleTypeId);
        if (mhf == null || this.mtRegistry.get((Object)moduleTypeId) == null) {
            return null;
        }
        return mhf.getHandler(m, ruleUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleHandlerFactory getModuleHandlerFactory(String moduleTypeId) {
        ModuleType mt;
        ModuleHandlerFactory mhf = null;
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            mhf = this.moduleHandlerFactories.get(moduleTypeId);
        }
        if (mhf == null && ((mt = (ModuleType)this.mtRegistry.get((Object)moduleTypeId)) instanceof CompositeTriggerType || mt instanceof CompositeConditionType || mt instanceof CompositeActionType)) {
            mhf = this.compositeFactory;
        }
        return mhf;
    }

    public synchronized void updateMapModuleTypeToRule(String rUID, String moduleTypeId) {
        Set<String> rules = this.mapModuleTypeToRules.get(moduleTypeId);
        if (rules == null) {
            rules = new HashSet<String>(11);
        }
        rules.add(rUID);
        this.mapModuleTypeToRules.put(moduleTypeId, rules);
    }

    protected synchronized boolean removeRule(String rUID) {
        RuntimeRule r = this.rules.remove(rUID);
        if (r != null) {
            this.removeRuleEntry(r);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeRule removeRuleEntry(RuntimeRule r) {
        this.unregister(r);
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            Iterator<Map.Entry<String, Set<String>>> it = this.mapModuleTypeToRules.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Set<String>> e = it.next();
                Set<String> rules = e.getValue();
                if (rules == null || !rules.contains(r.getUID())) continue;
                rules.remove(r.getUID());
                if (rules.size() >= 1) continue;
                it.remove();
            }
            this.statusMap.remove(r.getUID());
        }
        return r;
    }

    protected synchronized RuntimeRule getRuntimeRule(String rUID) {
        return this.rules.get(rUID);
    }

    protected synchronized Collection<RuntimeRule> getRuntimeRules() {
        return Collections.unmodifiableCollection(this.rules.values());
    }

    protected void setRuleEnabled(Rule rule, boolean isEnabled) {
        String rUID = rule.getUID();
        RuleStatus status = this.getRuleStatus(rUID);
        String enabled = isEnabled ? "enabled" : "disabled";
        RuntimeRule runtimeRule = this.getRuntimeRule(rUID);
        if (runtimeRule == null) {
            this.logger.debug("There is no rule with UID '{}' which could be {}", (Object)rUID, (Object)enabled);
            return;
        }
        if (isEnabled) {
            if (status == RuleStatus.DISABLED) {
                this.setRule(runtimeRule);
            } else {
                this.logger.debug("The rule rId = {} is already enabled.", (Object)rUID);
            }
        } else {
            this.unregister(runtimeRule);
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.DISABLED), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewModuleTypes(ModuleHandlerFactory mhf, Collection<String> moduleTypes) {
        Set notInitailizedRules = null;
        for (String moduleTypeName : moduleTypes) {
            HashSet<String> rules = null;
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                this.moduleHandlerFactories.put(moduleTypeName, mhf);
                Set<String> rulesPerModule = this.mapModuleTypeToRules.get(moduleTypeName);
                if (rulesPerModule != null) {
                    rules = new HashSet<String>();
                    rules.addAll(rulesPerModule);
                }
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.UNINITIALIZED) continue;
                notInitailizedRules = notInitailizedRules != null ? notInitailizedRules : new HashSet(20);
                notInitailizedRules.add(rUID);
            }
        }
        if (notInitailizedRules != null) {
            for (String rUID : notInitailizedRules) {
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    protected void scheduleRuleInitialization(final String rUID) {
        ScheduledFuture<?> f = this.scheduleTasks.get(rUID);
        if (f == null) {
            ScheduledExecutorService ex = this.getScheduledExecutor();
            f = ex.schedule(new Runnable(){

                @Override
                public void run() {
                    RuleEngine.this.setRule(RuleEngine.this.getRuntimeRule(rUID));
                }
            }, this.scheduleReinitializationDelay, TimeUnit.MILLISECONDS);
            this.scheduleTasks.put(rUID, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMissingModuleTypes(Collection<String> moduleTypes) {
        Map mapMissingHandlers = null;
        for (String moduleTypeName : moduleTypes) {
            Set<String> rules = null;
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                rules = this.mapModuleTypeToRules.get(moduleTypeName);
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                switch (ruleStatus) {
                    case IDLE: 
                    case RUNNING: {
                        mapMissingHandlers = mapMissingHandlers != null ? mapMissingHandlers : new HashMap(20);
                        ArrayList<String> list = (ArrayList<String>)mapMissingHandlers.get(rUID);
                        if (list == null) {
                            list = new ArrayList<String>(5);
                        }
                        list.add(moduleTypeName);
                        mapMissingHandlers.put(rUID, list);
                        break;
                    }
                }
            }
        }
        if (mapMissingHandlers != null) {
            for (Map.Entry e : mapMissingHandlers.entrySet()) {
                String rUID = (String)e.getKey();
                List missingTypes = (List)e.getValue();
                StringBuffer sb = new StringBuffer();
                sb.append("Missing handlers: ");
                for (String typeUID : missingTypes) {
                    sb.append(typeUID).append(", ");
                }
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.UNINITIALIZED, RuleStatusDetail.HANDLER_MISSING_ERROR, sb.substring(0, sb.length() - 2)), true);
                this.unregister(this.getRuntimeRule(rUID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runRule(RuntimeRule rule, RuleEngineCallbackImpl.TriggerData td) {
        String rUID = rule.getUID();
        if (this.reCallbacks.get(rUID) == null) {
            return;
        }
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            RuleStatus ruleStatus = this.getRuleStatus(rUID);
            if (ruleStatus != RuleStatus.IDLE) {
                this.logger.error("Failed to execute rule \u2018{}' with status '{}'", (Object)rUID, (Object)ruleStatus.name());
                return;
            }
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.RUNNING), true);
        }
        try {
            this.clearContext(rule);
            this.setTriggerOutputs(rUID, td);
            boolean isSatisfied = this.calculateConditions(rule);
            if (isSatisfied) {
                this.executeActions(rule, true);
                this.logger.debug("The rule '{}' is executed.", (Object)rUID);
            } else {
                this.logger.debug("The rule '{}' is NOT executed, since it has unsatisfied conditions.", (Object)rUID);
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to execute rule '{}': {}", (Object)rUID, (Object)t.getMessage());
            this.logger.debug("", t);
        }
        RuleEngine ruleEngine2 = this;
        synchronized (ruleEngine2) {
            if (this.getRuleStatus(rUID) == RuleStatus.RUNNING) {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.IDLE), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runNow(String ruleUID, boolean considerConditions, Map<String, Object> context) {
        RuntimeRule rule = this.getRuntimeRule(ruleUID);
        if (rule == null) {
            this.logger.warn("Failed to execute rule '{}': Invalid Rule UID", (Object)ruleUID);
            return;
        }
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            RuleStatus ruleStatus = this.getRuleStatus(ruleUID);
            if (ruleStatus != RuleStatus.IDLE) {
                this.logger.error("Failed to execute rule \u2018{}' with status '{}'", (Object)ruleUID, (Object)ruleStatus.name());
                return;
            }
            this.setRuleStatusInfo(ruleUID, new RuleStatusInfo(RuleStatus.RUNNING), true);
        }
        try {
            this.clearContext(rule);
            if (context != null && !context.isEmpty()) {
                this.getContext(ruleUID).putAll(context);
            }
            if (considerConditions) {
                if (this.calculateConditions(rule)) {
                    this.executeActions(rule, false);
                }
            } else {
                this.executeActions(rule, false);
            }
            this.logger.debug("The rule '{}' is executed.", (Object)ruleUID);
        }
        catch (Throwable t) {
            this.logger.error("Fail to execute rule '{}': {}", (Object)new Object[]{ruleUID, t.getMessage()}, (Object)t);
        }
        ruleEngine = this;
        synchronized (ruleEngine) {
            if (this.getRuleStatus(ruleUID) == RuleStatus.RUNNING) {
                this.setRuleStatusInfo(ruleUID, new RuleStatusInfo(RuleStatus.IDLE), true);
            }
        }
    }

    protected void runNow(String ruleUID) {
        this.runNow(ruleUID, false, null);
    }

    protected void clearContext(RuntimeRule rule) {
        Map<String, Object> context = this.contextMap.get(rule.getUID());
        if (context != null) {
            context.clear();
        }
    }

    private void setTriggerOutputs(String ruleUID, RuleEngineCallbackImpl.TriggerData td) {
        Trigger t = td.getTrigger();
        this.updateContext(ruleUID, t.getId(), td.getOutputs());
    }

    private void updateContext(String ruleUID, String moduleUID, Map<String, ?> outputs) {
        Map<String, Object> context = this.getContext(ruleUID);
        if (outputs != null) {
            for (Map.Entry<String, ?> entry : outputs.entrySet()) {
                String key = String.valueOf(moduleUID) + '.' + entry.getKey();
                context.put(key, entry.getValue());
            }
        }
    }

    private Map<String, Object> getContext(String ruleUID) {
        return this.getContext(ruleUID, null);
    }

    private Map<String, Object> getContext(String ruleUID, Set<Connection> connections) {
        Map<String, Object> context = this.contextMap.get(ruleUID);
        if (context == null) {
            context = new HashMap<String, Object>();
            this.contextMap.put(ruleUID, context);
        }
        if (connections != null) {
            StringBuffer sb = new StringBuffer();
            for (Connection c : connections) {
                String outputModuleId = c.getOuputModuleId();
                if (outputModuleId != null) {
                    sb.append(outputModuleId).append('.').append(c.getOutputName());
                    context.put(c.getInputName(), context.get(sb.toString()));
                    sb.setLength(0);
                    continue;
                }
                String ref = c.getOutputName();
                Object value = ReferenceResolverUtil.resolveReference(ref, context);
                if (value == null) continue;
                context.put(c.getInputName(), value);
            }
        }
        return context;
    }

    private boolean calculateConditions(Rule rule) {
        List conditions = ((RuntimeRule)rule).getConditions();
        if (conditions.size() == 0) {
            return true;
        }
        RuleStatus ruleStatus = null;
        Iterator it = conditions.iterator();
        while (it.hasNext()) {
            Map<String, Object> context;
            ruleStatus = this.getRuleStatus(rule.getUID());
            if (ruleStatus != RuleStatus.RUNNING) {
                return false;
            }
            RuntimeCondition c = (RuntimeCondition)((Object)it.next());
            ConditionHandler tHandler = c.getModuleHandler();
            if (tHandler.isSatisfied(Collections.unmodifiableMap(context = this.getContext(rule.getUID(), c.getConnections())))) continue;
            this.logger.debug("The condition '{}' of rule '{}' is unsatisfied.", new Object[]{c.getId(), rule.getUID()});
            return false;
        }
        return true;
    }

    private void executeActions(Rule rule, boolean stopOnFirstFail) {
        List actions = ((RuntimeRule)rule).getActions();
        if (actions.size() == 0) {
            return;
        }
        RuleStatus ruleStatus = null;
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            ruleStatus = this.getRuleStatus(rule.getUID());
            if (ruleStatus != RuleStatus.RUNNING) {
                return;
            }
            RuntimeAction action = (RuntimeAction)((Object)it.next());
            ActionHandler aHandler = action.getModuleHandler();
            String rUID = rule.getUID();
            Map<String, Object> context = this.getContext(rUID, action.getConnections());
            try {
                Map outputs = aHandler.execute(Collections.unmodifiableMap(context));
                if (outputs == null) continue;
                context = this.getContext(rUID);
                this.updateContext(rUID, action.getId(), outputs);
            }
            catch (Throwable t) {
                String errMessage = "Fail to execute action: " + action.getId();
                if (stopOnFirstFail) {
                    RuntimeException re = new RuntimeException(errMessage, t);
                    throw re;
                }
                this.logger.warn(errMessage, t);
            }
        }
    }

    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            Iterator<RuntimeRule> it = this.rules.values().iterator();
            while (it.hasNext()) {
                RuntimeRule r = it.next();
                this.removeRuleEntry(r);
                it.remove();
            }
            if (this.compositeFactory != null) {
                this.compositeFactory.dispose();
                this.compositeFactory = null;
            }
        }
        for (Future f : this.scheduleTasks.values()) {
            f.cancel(true);
        }
        if (this.scheduleTasks.isEmpty() && this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.scheduleTasks = null;
        if (this.contextMap != null) {
            this.contextMap.clear();
            this.contextMap = null;
        }
        this.statusInfoCallback = null;
    }

    protected RuleStatus getRuleStatus(String rUID) {
        RuleStatusInfo info = this.getRuleStatusInfo(rUID);
        RuleStatus status = null;
        if (info != null) {
            status = info.getStatus();
        }
        return status;
    }

    protected synchronized RuleStatusInfo getRuleStatusInfo(String rUID) {
        return this.statusMap.get(rUID);
    }

    protected void setStatusInfoCallback(StatusInfoCallback statusInfoCallback) {
        this.statusInfoCallback = statusInfoCallback;
    }

    private ScheduledExecutorService getScheduledExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        return this.executor;
    }

    protected void scheduleRulesConfigurationUpdated(Map<String, Object> config) {
        if (config != null) {
            Object value = config.get(CONFIG_PROPERTY_REINITIALIZATION_DELAY);
            if (value != null) {
                if (value instanceof Number) {
                    this.scheduleReinitializationDelay = ((Number)value).longValue();
                } else {
                    this.logger.error("Invalid configuration value: {}. It MUST be Number.", value);
                }
            } else {
                this.scheduleReinitializationDelay = 500L;
            }
        } else {
            this.scheduleReinitializationDelay = 500L;
        }
    }

    private void autoMapConnections(RuntimeRule r) {
        Map<String, String> connectionMap;
        Set<Connection> connections;
        HashMap<Set<String>, OutputRef> triggerOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (Trigger t : r.getTriggers()) {
            TriggerType tt = (TriggerType)this.mtRegistry.get((Object)t.getTypeUID());
            if (tt == null) continue;
            this.initTagsMap(t.getId(), tt.getOutputs(), triggerOutputTags);
        }
        HashMap<Set<String>, OutputRef> actionOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (Action a : r.getActions()) {
            ActionType at = (ActionType)this.mtRegistry.get((Object)a.getTypeUID());
            if (at == null) continue;
            this.initTagsMap(a.getId(), at.getOutputs(), actionOutputTags);
        }
        if (!triggerOutputTags.isEmpty()) {
            for (Condition c : r.getConditions()) {
                boolean isConnectionChanged = false;
                ConditionType ct = (ConditionType)this.mtRegistry.get((Object)c.getTypeUID());
                if (ct == null) continue;
                connections = ((RuntimeCondition)c).getConnections();
                for (Input input : ct.getInputs()) {
                    if (this.isConnected(input, connections) || !this.addAutoMapConnections(input, triggerOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connections = ((RuntimeCondition)c).getConnections();
                connectionMap = this.getConnectionMap(connections);
                c.setInputs(connectionMap);
            }
        }
        if (!triggerOutputTags.isEmpty() || !actionOutputTags.isEmpty()) {
            for (Action a : r.getActions()) {
                boolean isConnectionChanged = false;
                ActionType at = (ActionType)this.mtRegistry.get((Object)a.getTypeUID());
                if (at == null) continue;
                connections = ((RuntimeAction)a).getConnections();
                for (Input input : at.getInputs()) {
                    if (this.isConnected(input, connections)) continue;
                    if (this.addAutoMapConnections(input, triggerOutputTags, connections)) {
                        isConnectionChanged = true;
                    }
                    if (!this.addAutoMapConnections(input, actionOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connections = ((RuntimeAction)a).getConnections();
                connectionMap = this.getConnectionMap(connections);
                a.setInputs(connectionMap);
            }
        }
    }

    private boolean addAutoMapConnections(Input input, Map<Set<String>, OutputRef> outputTagMap, Set<Connection> currentConnections) {
        boolean result = false;
        Set inputTags = input.getTags();
        OutputRef outputRef = null;
        boolean conflict = false;
        if (inputTags.size() > 0) {
            for (Set<String> outTags : outputTagMap.keySet()) {
                if (!outTags.containsAll(inputTags)) continue;
                if (outputRef == null) {
                    outputRef = outputTagMap.get(outTags);
                    continue;
                }
                conflict = true;
                break;
            }
            if (!conflict && outputRef != null) {
                if (currentConnections == null) {
                    currentConnections = new HashSet<Connection>(11);
                }
                currentConnections.add(new Connection(input.getName(), outputRef.getModuleId(), outputRef.getOutputName()));
                result = true;
            }
        }
        return result;
    }

    private void initTagsMap(String moduleId, List<Output> outputs, Map<Set<String>, OutputRef> tagMap) {
        for (Output output : outputs) {
            Set tags = output.getTags();
            if (tags.size() <= 0) continue;
            if (tagMap.get(tags) != null) {
                tagMap.remove(tags);
                continue;
            }
            tagMap.put(tags, new OutputRef(moduleId, output.getName()));
        }
    }

    private boolean isConnected(Input input, Set<Connection> connections) {
        if (connections != null) {
            for (Connection connection : connections) {
                if (!connection.getInputName().equals(input.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, String> getConnectionMap(Set<Connection> connections) {
        HashMap<String, String> connectionMap = new HashMap<String, String>(11);
        for (Connection connection : connections) {
            connectionMap.put(connection.getInputName(), String.valueOf(connection.getOuputModuleId()) + "." + connection.getOutputName());
        }
        return connectionMap;
    }

    protected void resolveConfiguration(Rule rule) {
        List configDescriptions = rule.getConfigurationDescriptions();
        Map configuration = rule.getConfiguration().getProperties();
        if (configuration != null) {
            this.handleModuleConfigReferences(rule.getTriggers(), configuration);
            this.handleModuleConfigReferences(rule.getConditions(), configuration);
            this.handleModuleConfigReferences(rule.getActions(), configuration);
        }
        this.normalizeRuleConfigurations(rule);
        this.validateConfiguration(rule.getUID(), configDescriptions, new HashMap<String, Object>(configuration));
    }

    private void validateConfiguration(String uid, List<ConfigDescriptionParameter> configDescriptions, Map<String, Object> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            if (this.isOptionalConfig(configDescriptions)) {
                return;
            }
            for (ConfigDescriptionParameter configParameter : configDescriptions) {
                if (!configParameter.isRequired()) continue;
                this.logger.error("Missing required configuration property '{}' for rule with UID '{}'!", (Object)configParameter.getName(), (Object)uid);
            }
            throw new IllegalArgumentException("Missing required configuration properties!");
        }
        for (ConfigDescriptionParameter configParameter : configDescriptions) {
            String configParameterName = configParameter.getName();
            this.processValue(configurations.remove(configParameterName), configParameter);
        }
        for (String name : configurations.keySet()) {
            this.logger.error("Extra configuration property '{}' for rule with UID '{}'!", (Object)name, (Object)uid);
        }
        if (!configurations.isEmpty()) {
            throw new IllegalArgumentException("Extra configuration properties!");
        }
    }

    private boolean isOptionalConfig(List<ConfigDescriptionParameter> configDescriptions) {
        if (configDescriptions != null && !configDescriptions.isEmpty()) {
            boolean required = false;
            for (ConfigDescriptionParameter param : configDescriptions) {
                boolean bl = required = required || param.isRequired();
            }
            return !required;
        }
        return true;
    }

    private void processValue(Object configValue, ConfigDescriptionParameter configParameter) {
        if (configValue != null) {
            this.checkType(configValue, configParameter);
            return;
        }
        if (configParameter.isRequired()) {
            throw new IllegalArgumentException("Required configuration property missing: \"" + configParameter.getName() + "\"!");
        }
    }

    private void checkType(Object configValue, ConfigDescriptionParameter configParameter) {
        ConfigDescriptionParameter.Type type = configParameter.getType();
        if (configParameter.isMultiple().booleanValue()) {
            if (configValue instanceof List) {
                List lConfigValues = (List)configValue;
                for (Object value : lConfigValues) {
                    if (this.checkType(type, value)) continue;
                    throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected type: " + type);
                }
            }
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is Array with type for elements : " + type.toString() + "!");
        }
        if (!this.checkType(type, configValue)) {
            throw new IllegalArgumentException("Unexpected value for configuration property \"" + configParameter.getName() + "\". Expected is " + type.toString() + "!");
        }
    }

    private boolean checkType(ConfigDescriptionParameter.Type type, Object configValue) {
        switch (type) {
            case TEXT: {
                return configValue instanceof String;
            }
            case BOOLEAN: {
                return configValue instanceof Boolean;
            }
            case INTEGER: {
                return configValue instanceof BigDecimal || configValue instanceof Integer || configValue instanceof Double && (double)((Double)configValue).intValue() == (Double)configValue;
            }
            case DECIMAL: {
                return configValue instanceof BigDecimal || configValue instanceof Double;
            }
        }
        return false;
    }

    private void handleModuleConfigReferences(List<? extends Module> modules, Map<String, ?> ruleConfiguration) {
        if (modules != null) {
            for (Module module : modules) {
                ReferenceResolverUtil.updateModuleConfiguration(module, ruleConfiguration);
            }
        }
    }

    private void normalizeRuleConfigurations(Rule rule) {
        List configDescriptions = rule.getConfigurationDescriptions();
        Map<String, ConfigDescriptionParameter> mapConfigDescriptions = this.getConfigDescriptionMap(configDescriptions);
        this.normalizeConfiguration(rule.getConfiguration(), mapConfigDescriptions);
        this.normalizeModuleConfigurations(rule.getTriggers());
        this.normalizeModuleConfigurations(rule.getConditions());
        this.normalizeModuleConfigurations(rule.getActions());
    }

    private <T extends Module> void normalizeModuleConfigurations(List<@NonNull T> modules) {
        for (Module module : modules) {
            String type;
            ModuleType mt;
            Configuration config = module.getConfiguration();
            if (config == null || (mt = (ModuleType)this.mtRegistry.get((Object)(type = module.getTypeUID()))) == null) continue;
            List configDescriptions = mt.getConfigurationDescriptions();
            Map<String, ConfigDescriptionParameter> mapConfigDescriptions = this.getConfigDescriptionMap(configDescriptions);
            this.normalizeConfiguration(config, mapConfigDescriptions);
        }
    }

    private Map<String, ConfigDescriptionParameter> getConfigDescriptionMap(List<ConfigDescriptionParameter> configDesc) {
        HashMap<String, ConfigDescriptionParameter> mapConfigDescs = null;
        if (configDesc != null) {
            for (ConfigDescriptionParameter configDescriptionParameter : configDesc) {
                if (mapConfigDescs == null) {
                    mapConfigDescs = new HashMap<String, ConfigDescriptionParameter>();
                }
                mapConfigDescs.put(configDescriptionParameter.getName(), configDescriptionParameter);
            }
        }
        return mapConfigDescs;
    }

    private void normalizeConfiguration(Configuration config, Map<String, ConfigDescriptionParameter> mapCD) {
        if (config != null && mapCD != null) {
            for (String propName : mapCD.keySet()) {
                Object value;
                ConfigDescriptionParameter cd = mapCD.get(propName);
                if (cd != null) {
                    Object tmp = config.get(propName);
                    String defaultValue = cd.getDefault();
                    if (tmp == null && defaultValue != null) {
                        config.put(propName, (Object)defaultValue);
                    }
                    if (cd.isMultiple().booleanValue() && (tmp = config.get(propName)) != null && tmp instanceof String) {
                        String sValue = (String)tmp;
                        if (this.gson == null) {
                            this.gson = new Gson();
                        }
                        try {
                            Object value2 = this.gson.fromJson(sValue, List.class);
                            config.put(propName, value2);
                        }
                        catch (JsonSyntaxException e) {
                            this.logger.error("Can't parse {} to list value.", (Object)sValue, (Object)e);
                        }
                        continue;
                    }
                }
                if ((value = ConfigUtil.normalizeType((Object)config.get(propName), (ConfigDescriptionParameter)cd)) == null) continue;
                config.put(propName, value);
            }
        }
    }

    class OutputRef {
        private final String moduleId;
        private final String outputName;

        public OutputRef(String moduleId, String outputName) {
            this.moduleId = moduleId;
            this.outputName = outputName;
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public String getOutputName() {
            return this.outputName;
        }
    }
}

