/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.core.internal.composite.AbstractCompositeModuleHandler;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.Output;

public class CompositeTriggerHandler
extends AbstractCompositeModuleHandler<Trigger, CompositeTriggerType, TriggerHandler>
implements TriggerHandler,
RuleEngineCallback {
    private RuleEngineCallback ruleCallback;

    public CompositeTriggerHandler(Trigger trigger, CompositeTriggerType mt, LinkedHashMap<Trigger, TriggerHandler> mapModuleToHandler, String ruleUID) {
        super(trigger, mt, mapModuleToHandler);
    }

    public void triggered(Trigger trigger, Map<String, ?> context) {
        if (this.ruleCallback != null) {
            List outputs = ((CompositeTriggerType)this.moduleType).getOutputs();
            HashMap<String, Object> result = new HashMap<String, Object>(11);
            for (Output output : outputs) {
                String refs = output.getReference();
                if (refs == null) continue;
                StringTokenizer st = new StringTokenizer(refs, ",");
                while (st.hasMoreTokens()) {
                    String ref = st.nextToken().trim();
                    int i = ref.indexOf(46);
                    if (i != -1) {
                        String childModuleId = ref.substring(0, i);
                        if (trigger.getId().equals(childModuleId)) {
                            ref = ref.substring(i + 1);
                        }
                    }
                    Object value = null;
                    int idx = ReferenceResolverUtil.getNextRefToken(ref, 1);
                    if (idx < ref.length()) {
                        String outputId = ref.substring(0, idx);
                        value = ReferenceResolverUtil.getValue(context.get(outputId), ref.substring(idx + 1));
                    } else {
                        value = context.get(ref);
                    }
                    if (value == null) continue;
                    result.put(output.getName(), value);
                }
            }
            this.ruleCallback.triggered((Trigger)this.module, result);
        }
    }

    public void setRuleEngineCallback(RuleEngineCallback ruleCallback) {
        this.ruleCallback = ruleCallback;
        if (ruleCallback != null) {
            List<Trigger> children = this.getChildren();
            for (Trigger child : children) {
                TriggerHandler handler = (TriggerHandler)this.moduleHandlerMap.get(child);
                handler.setRuleEngineCallback((RuleEngineCallback)this);
            }
        }
    }

    @Override
    public void dispose() {
        this.setRuleEngineCallback(null);
        super.dispose();
    }

    @Override
    protected List<Trigger> getChildren() {
        return ((CompositeTriggerType)this.moduleType).getChildren();
    }
}

