/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.RuleTemplateProvider;
import org.eclipse.smarthome.automation.template.TemplateProvider;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.common.registry.Provider;

public class RuleTemplateRegistry
extends AbstractRegistry<RuleTemplate, String, RuleTemplateProvider>
implements TemplateRegistry<RuleTemplate> {
    public RuleTemplateRegistry() {
        super(RuleTemplateProvider.class);
    }

    protected void addProvider(Provider<RuleTemplate> provider) {
        if (provider instanceof TemplateProvider) {
            super.addProvider(provider);
        }
    }

    public RuleTemplate get(String templateUID) {
        return this.get(templateUID, null);
    }

    public RuleTemplate get(String templateUID, Locale locale) {
        for (Provider provider : this.elementMap.keySet()) {
            for (RuleTemplate resultTemplate : (Collection)this.elementMap.get(provider)) {
                if (!resultTemplate.getUID().equals(templateUID)) continue;
                RuleTemplate t = locale == null ? resultTemplate : (RuleTemplate)((RuleTemplateProvider)provider).getTemplate(templateUID, locale);
                return this.createCopy(t);
            }
        }
        return null;
    }

    private RuleTemplate createCopy(RuleTemplate template) {
        return new RuleTemplate(template.getUID(), template.getLabel(), template.getDescription(), new HashSet(template.getTags()), this.copyTriggers(template.getTriggers()), this.copyConditions(template.getConditions()), this.copyActions(template.getActions()), new LinkedList(template.getConfigurationDescriptions()), template.getVisibility());
    }

    private List<Trigger> copyTriggers(List<Trigger> triggers) {
        ArrayList<Trigger> res = new ArrayList<Trigger>(11);
        if (triggers != null) {
            for (Trigger t : triggers) {
                Configuration c = new Configuration();
                c.setProperties(t.getConfiguration().getProperties());
                Trigger trigger = new Trigger(t.getId(), t.getTypeUID(), c);
                trigger.setLabel(t.getLabel());
                trigger.setDescription(t.getDescription());
                res.add(trigger);
            }
        }
        return res;
    }

    private List<Condition> copyConditions(List<Condition> conditions) {
        ArrayList<Condition> res = new ArrayList<Condition>(11);
        if (conditions != null) {
            for (Condition c : conditions) {
                Configuration conf = new Configuration();
                conf.setProperties(c.getConfiguration().getProperties());
                Condition condition = new Condition(c.getId(), c.getTypeUID(), conf, new HashMap(c.getInputs()));
                condition.setLabel(c.getLabel());
                condition.setDescription(c.getDescription());
                res.add(condition);
            }
        }
        return res;
    }

    private List<Action> copyActions(List<Action> actions) {
        ArrayList<Action> res = new ArrayList<Action>();
        if (actions != null) {
            for (Action a : actions) {
                Configuration c = new Configuration();
                c.setProperties(a.getConfiguration().getProperties());
                Action action = new Action(a.getId(), a.getTypeUID(), c, a.getInputs());
                action.setLabel(a.getLabel());
                action.setDescription(a.getDescription());
                res.add(action);
            }
        }
        return res;
    }

    public Collection<RuleTemplate> getByTag(String tag) {
        return this.getByTag(tag, null);
    }

    public Collection<RuleTemplate> getByTag(String tag, Locale locale) {
        ArrayList<RuleTemplate> result = new ArrayList<RuleTemplate>(20);
        for (Provider provider : this.elementMap.keySet()) {
            for (RuleTemplate resultTemplate : (Collection)this.elementMap.get(provider)) {
                RuleTemplate t;
                Set tags = resultTemplate.getTags();
                RuleTemplate ruleTemplate = t = locale == null ? resultTemplate : (RuleTemplate)((RuleTemplateProvider)provider).getTemplate(resultTemplate.getUID(), locale);
                if (tag == null) {
                    result.add(t);
                    continue;
                }
                if (tags == null || !tags.contains(tag)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public Collection<RuleTemplate> getByTags(String ... tags) {
        return this.getByTags((Locale)null, tags);
    }

    public Collection<RuleTemplate> getByTags(Locale locale, String ... tags) {
        HashSet<String> tagSet = tags != null ? new HashSet<String>(Arrays.asList(tags)) : null;
        ArrayList<RuleTemplate> result = new ArrayList<RuleTemplate>(20);
        for (Provider provider : this.elementMap.keySet()) {
            for (RuleTemplate resultTemplate : (Collection)this.elementMap.get(provider)) {
                RuleTemplate t;
                Set tTags = resultTemplate.getTags();
                RuleTemplate ruleTemplate = t = locale == null ? resultTemplate : (RuleTemplate)((RuleTemplateProvider)provider).getTemplate(resultTemplate.getUID(), locale);
                if (tagSet == null) {
                    result.add(t);
                    continue;
                }
                if (tTags == null || !tTags.containsAll(tagSet)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public Collection<RuleTemplate> getAll(Locale locale) {
        return this.getByTag(null, locale);
    }
}

