/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.net.http.internal;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smarthome.io.net.http.HttpContextFactoryService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.HttpContext;

@Component(service={HttpContextFactoryService.class})
public class HttpContextFactoryServiceImpl
implements HttpContextFactoryService {
    @Override
    public HttpContext createDefaultHttpContext(Bundle bundle) {
        return new DefaultHttpContext(bundle);
    }

    private class DefaultHttpContext
    implements HttpContext {
        private final Bundle bundle;

        private DefaultHttpContext(Bundle bundle) {
            this.bundle = bundle;
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return true;
        }

        public URL getResource(String name) {
            if (name != null) {
                String resourceName = name.startsWith("/") ? name.substring(1) : name;
                return this.bundle.getResource(resourceName);
            }
            return null;
        }

        public String getMimeType(String name) {
            return null;
        }
    }
}

