/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.rest.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.automation.dto.ActionTypeDTOMapper;
import org.eclipse.smarthome.automation.dto.ConditionTypeDTOMapper;
import org.eclipse.smarthome.automation.dto.ModuleTypeDTO;
import org.eclipse.smarthome.automation.dto.TriggerTypeDTOMapper;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;

@Path(value="module-types")
@Api(value="module-types")
public class ModuleTypeResource
implements RESTResource {
    private ModuleTypeRegistry moduleTypeRegistry;
    @Context
    private UriInfo uriInfo;

    protected void setModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = moduleTypeRegistry;
    }

    protected void unsetModuleTypeRegistry(ModuleTypeRegistry moduleTypeRegistry) {
        this.moduleTypeRegistry = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available module types.", response=ModuleTypeDTO.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ModuleTypeDTO.class, responseContainer="List")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @QueryParam(value="tags") @ApiParam(value="tags for filtering", required=false) String tagList, @QueryParam(value="type") @ApiParam(value="filtering by action, condition or trigger", required=false) String type) {
        Locale locale = LocaleUtil.getLocale((String)language);
        String[] tags = tagList != null ? tagList.split(",") : null;
        ArrayList modules = new ArrayList();
        if (type == null || type.equals("trigger")) {
            modules.addAll(TriggerTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getTriggers(locale, tags)));
        }
        if (type == null || type.equals("condition")) {
            modules.addAll(ConditionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getConditions(locale, tags)));
        }
        if (type == null || type.equals("action")) {
            modules.addAll(ActionTypeDTOMapper.map((Collection)this.moduleTypeRegistry.getActions(locale, tags)));
        }
        return Response.ok(modules).build();
    }

    @GET
    @Path(value="/{moduleTypeUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets a module type corresponding to the given UID.", response=ModuleTypeDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ModuleTypeDTO.class), @ApiResponse(code=404, message="Module Type corresponding to the given UID does not found.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="moduleTypeUID") @ApiParam(value="moduleTypeUID", required=true) String moduleTypeUID) {
        Locale locale = LocaleUtil.getLocale((String)language);
        ModuleType moduleType = this.moduleTypeRegistry.get(moduleTypeUID, locale);
        if (moduleType != null) {
            return Response.ok((Object)this.getModuleTypeDTO(moduleType)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private ModuleTypeDTO getModuleTypeDTO(ModuleType moduleType) {
        if (moduleType instanceof ActionType) {
            if (moduleType instanceof CompositeActionType) {
                return ActionTypeDTOMapper.map((CompositeActionType)((CompositeActionType)moduleType));
            }
            return ActionTypeDTOMapper.map((ActionType)((ActionType)moduleType));
        }
        if (moduleType instanceof ConditionType) {
            if (moduleType instanceof CompositeConditionType) {
                return ConditionTypeDTOMapper.map((CompositeConditionType)((CompositeConditionType)moduleType));
            }
            return ConditionTypeDTOMapper.map((ConditionType)((ConditionType)moduleType));
        }
        if (moduleType instanceof TriggerType) {
            if (moduleType instanceof CompositeTriggerType) {
                return TriggerTypeDTOMapper.map((CompositeTriggerType)((CompositeTriggerType)moduleType));
            }
            return TriggerTypeDTOMapper.map((TriggerType)((TriggerType)moduleType));
        }
        throw new IllegalArgumentException(String.format("Cannot handle given module type class (%s)", moduleType.getClass()));
    }

    public boolean isSatisfied() {
        return this.moduleTypeRegistry != null;
    }
}

