/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.auth.jaas.internal;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.smarthome.core.auth.Authentication;
import org.eclipse.smarthome.core.auth.AuthenticationException;
import org.eclipse.smarthome.core.auth.AuthenticationProvider;
import org.eclipse.smarthome.core.auth.Credentials;
import org.eclipse.smarthome.core.auth.UsernamePasswordCredentials;

public class JaasAuthenticationProvider
implements AuthenticationProvider {
    private String realmName;

    public Authentication authenticate(Credentials credentials) {
        if (this.realmName == null) {
            return null;
        }
        final String name = this.getName(credentials);
        final char[] password = this.getPassword(credentials);
        try {
            LoginContext loginContext = new LoginContext(this.realmName, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    Callback[] callbackArray = callbacks;
                    int n = callbacks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Callback callback = callbackArray[n2];
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password);
                        } else if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(name);
                        } else {
                            throw new UnsupportedCallbackException(callback);
                        }
                        ++n2;
                    }
                }
            });
            loginContext.login();
            return this.getAuthentication(name, loginContext.getSubject());
        }
        catch (LoginException e) {
            throw new AuthenticationException("Could not obtain authentication over login context", (Throwable)e);
        }
    }

    private Authentication getAuthentication(String name, Subject subject) {
        return new Authentication(name, this.getRoles(subject.getPrincipals()));
    }

    private String[] getRoles(Set<Principal> principals) {
        String[] roles = new String[principals.size()];
        int i = 0;
        for (Principal principal : principals) {
            roles[i++] = principal.getName();
        }
        return roles;
    }

    private String getName(Credentials credentials) {
        if (credentials instanceof UsernamePasswordCredentials) {
            return ((UsernamePasswordCredentials)credentials).getUsername();
        }
        return null;
    }

    private char[] getPassword(Credentials credentials) {
        if (credentials instanceof UsernamePasswordCredentials) {
            return ((UsernamePasswordCredentials)credentials).getPassword().toCharArray();
        }
        return null;
    }

    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    protected void deactivate(Map<String, Object> properties) {
    }

    protected void modified(Map<String, Object> properties) {
        if (properties == null) {
            this.realmName = null;
            return;
        }
        Object propertyValue = properties.get("realmName");
        this.realmName = propertyValue != null ? (propertyValue instanceof String ? (String)propertyValue : propertyValue.toString()) : null;
    }
}

