/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.extensionservice.marketplace.automation.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.RuleTemplateProvider;
import org.eclipse.smarthome.core.common.registry.DefaultAbstractManagedProvider;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketplaceRuleTemplateProvider
extends DefaultAbstractManagedProvider<RuleTemplate, String>
implements RuleTemplateProvider {
    private final Logger logger = LoggerFactory.getLogger(MarketplaceRuleTemplateProvider.class);
    private Parser<RuleTemplate> parser;

    public RuleTemplate getTemplate(String uid, Locale locale) {
        return (RuleTemplate)this.get(uid);
    }

    public Collection<RuleTemplate> getTemplates(Locale locale) {
        return this.getAll();
    }

    protected String getStorageName() {
        return "org.eclipse.smarthome.extensionservice.marketplace.RuleTemplates";
    }

    protected String keyToString(String key) {
        return key;
    }

    protected void setParser(Parser<RuleTemplate> parser) {
        this.parser = parser;
    }

    protected void unsetParser(Parser<RuleTemplate> parser) {
        this.parser = null;
    }

    public void addTemplateAsJSON(String uid, String json) throws ParsingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader isr = new InputStreamReader(IOUtils.toInputStream((String)json));){
                Set templates = this.parser.parse(isr);
                if (templates.size() != 1) {
                    throw new IllegalArgumentException("JSON must contain exactly one template!");
                }
                RuleTemplate entry = (RuleTemplate)templates.iterator().next();
                RuleTemplate template = new RuleTemplate(uid, entry.getLabel(), entry.getDescription(), entry.getTags(), entry.getTriggers(), entry.getConditions(), entry.getActions(), entry.getConfigurationDescriptions(), entry.getVisibility());
                this.add((Identifiable)template);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Cannot close input stream.", (Throwable)e);
        }
    }
}

