/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon;

import java.io.InputStream;
import java.util.Set;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceIconProvider
implements IconProvider {
    private final Logger logger = LoggerFactory.getLogger(AbstractResourceIconProvider.class);
    protected BundleContext context;
    protected TranslationProvider i18nProvider;

    protected void activate(BundleContext context) {
        this.context = context;
    }

    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = null;
    }

    @Override
    public Set<IconSet> getIconSets() {
        return this.getIconSets(null);
    }

    @Override
    public Integer hasIcon(String category, String iconSetId, IconSet.Format format) {
        return this.hasResource(iconSetId, String.valueOf(category.toLowerCase()) + "." + format.toString().toLowerCase()) ? this.getPriority() : null;
    }

    @Override
    public InputStream getIcon(String category, String iconSetId, String state, IconSet.Format format) {
        String resourceWithoutState = String.valueOf(category.toLowerCase()) + "." + format.toString().toLowerCase();
        if (state == null) {
            return this.getResource(iconSetId, resourceWithoutState);
        }
        String resourceWithState = String.valueOf(category.toLowerCase()) + "-" + state.toLowerCase() + "." + format.toString().toLowerCase();
        if (this.hasResource(iconSetId, resourceWithState)) {
            return this.getResource(iconSetId, resourceWithState);
        }
        try {
            Double stateAsDouble = Double.valueOf(state);
            if (stateAsDouble >= 0.0 && stateAsDouble <= 100.0) {
                int i = stateAsDouble.intValue();
                while (i >= 0) {
                    String resourceWithNumberState = String.valueOf(category.toLowerCase()) + "-" + i + "." + format.toString().toLowerCase();
                    if (this.hasResource(iconSetId, resourceWithNumberState)) {
                        return this.getResource(iconSetId, resourceWithNumberState);
                    }
                    --i;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.logger.debug("Use icon {} as {} is not found", (Object)resourceWithoutState, (Object)resourceWithState);
        return this.getResource(iconSetId, resourceWithoutState);
    }

    protected abstract Integer getPriority();

    protected abstract InputStream getResource(String var1, String var2);

    protected abstract boolean hasResource(String var1, String var2);
}

