/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.icon.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconServlet
extends HttpServlet {
    private static final long serialVersionUID = 2880642275858634578L;
    private final Logger logger = LoggerFactory.getLogger(IconServlet.class);
    private static final String SERVLET_NAME = "/icon";
    private static final String PARAM_ICONSET = "iconset";
    private static final String PARAM_FORMAT = "format";
    private static final String PARAM_STATE = "state";
    private long startupTime;
    protected HttpService httpService;
    protected String defaultIconSetId = "classic";
    private List<IconProvider> iconProvider = new ArrayList<IconProvider>();

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    public void addIconProvider(IconProvider iconProvider) {
        this.iconProvider.add(iconProvider);
    }

    public void removeIconProvider(IconProvider iconProvider) {
        this.iconProvider.remove(iconProvider);
    }

    protected void activate(Map<String, Object> config) {
        try {
            this.logger.debug("Starting up icon servlet at /icon");
            Hashtable props = new Hashtable();
            this.httpService.registerServlet(SERVLET_NAME, (Servlet)this, props, this.createHttpContext());
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
        this.startupTime = System.currentTimeMillis();
        this.modified(config);
    }

    protected void modified(Map<String, Object> config) {
        Object iconSetId = config.get("default");
        if (iconSetId instanceof String) {
            this.defaultIconSetId = (String)iconSetId;
        }
    }

    protected HttpContext createHttpContext() {
        HttpContext defaultHttpContext = this.httpService.createDefaultHttpContext();
        return defaultHttpContext;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getDateHeader("If-Modified-Since") > this.startupTime) {
            resp.setStatus(304);
            return;
        }
        String category = this.getCategory(req);
        IconSet.Format format = this.getFormat(req);
        String state = this.getState(req);
        String iconSetId = this.getIconSetId(req);
        IconProvider topProvider = this.getIconProvider(category, iconSetId, format);
        if (topProvider == null) {
            this.logger.debug("Requested icon category {} provided by no icon provider;", (Object)category);
            resp.sendError(404);
            return;
        }
        if (format.equals((Object)IconSet.Format.SVG)) {
            resp.setContentType("image/svg+xml");
        } else {
            resp.setContentType("image/png");
        }
        resp.setDateHeader("Last-Modified", new Date().getTime());
        ServletOutputStream os = resp.getOutputStream();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (InputStream is = topProvider.getIcon(category, iconSetId, state, format);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                resp.flushBuffer();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Failed sending the icon byte stream as a response: {}", (Object)e.getMessage());
            resp.sendError(500, e.getMessage());
        }
    }

    private String getCategory(HttpServletRequest req) {
        String category = StringUtils.substringAfterLast((String)req.getRequestURI(), (String)"/");
        category = StringUtils.substringBeforeLast((String)category, (String)".");
        return StringUtils.substringBeforeLast((String)category, (String)"-");
    }

    private IconSet.Format getFormat(HttpServletRequest req) {
        String format = req.getParameter(PARAM_FORMAT);
        if (format == null) {
            String filename = StringUtils.substringAfterLast((String)req.getRequestURI(), (String)"/");
            format = StringUtils.substringAfterLast((String)filename, (String)".");
        }
        try {
            IconSet.Format f = IconSet.Format.valueOf(format.toUpperCase());
            return f;
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("unknown format '{}' in HTTP request - falling back to PNG", (Object)format);
            return IconSet.Format.PNG;
        }
    }

    private String getIconSetId(HttpServletRequest req) {
        String iconSetId = req.getParameter(PARAM_ICONSET);
        if (iconSetId == null || iconSetId.isEmpty()) {
            return this.defaultIconSetId;
        }
        return iconSetId;
    }

    private String getState(HttpServletRequest req) {
        String state = req.getParameter(PARAM_STATE);
        if (state != null) {
            return state;
        }
        String filename = StringUtils.substringAfterLast((String)req.getRequestURI(), (String)"/");
        state = StringUtils.substringAfterLast((String)filename, (String)"-");
        if (StringUtils.isNotEmpty((String)(state = StringUtils.substringBeforeLast((String)state, (String)".")))) {
            return state;
        }
        return null;
    }

    private IconProvider getIconProvider(String category, String iconSetId, IconSet.Format format) {
        IconProvider topProvider = null;
        int maxPrio = Integer.MIN_VALUE;
        for (IconProvider provider : this.iconProvider) {
            Integer prio = provider.hasIcon(category, iconSetId, format);
            if (prio == null || prio <= maxPrio) continue;
            maxPrio = prio;
            topProvider = provider;
        }
        return topProvider;
    }
}

