/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.rfc147.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.smarthome.io.console.extensions.ConsoleCommandExtension;
import org.eclipse.smarthome.io.console.rfc147.internal.CommandWrapper;
import org.eclipse.smarthome.io.console.rfc147.internal.ConsoleCommandsContainer;
import org.eclipse.smarthome.io.console.rfc147.internal.OSGiConsole;
import org.eclipse.smarthome.io.console.rfc147.internal.extension.HelpConsoleCommandExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleSupportRfc147
implements ConsoleCommandsContainer {
    private static final String KEY_SCOPE = "osgi.command.scope";
    private static final String KEY_FUNCTION = "osgi.command.function";
    private static final String SCOPE = "smarthome";
    public static final OSGiConsole CONSOLE = new OSGiConsole("smarthome");
    private Logger logger = LoggerFactory.getLogger(ConsoleSupportRfc147.class);
    private final HelpConsoleCommandExtension helpCommand = new HelpConsoleCommandExtension();
    private BundleContext bc;
    private final Map<ConsoleCommandExtension, ServiceRegistration<?>> commands = Collections.synchronizedMap(new HashMap());

    public ConsoleSupportRfc147() {
        this.commands.put((ConsoleCommandExtension)this.helpCommand, null);
    }

    public void activate(ComponentContext ctx) {
        this.bc = ctx.getBundleContext();
        for (Map.Entry<ConsoleCommandExtension, ServiceRegistration<?>> entry : this.commands.entrySet()) {
            if (entry.getValue() != null) continue;
            entry.setValue(this.registerCommand(entry.getKey()));
        }
        this.helpCommand.setConsoleCommandsContainer(this);
    }

    public void deactivate() {
        this.helpCommand.setConsoleCommandsContainer(null);
        for (Map.Entry<ConsoleCommandExtension, ServiceRegistration<?>> entry : this.commands.entrySet()) {
            if (entry.getValue() == null) continue;
            this.unregisterCommand(entry.getValue());
            entry.setValue(null);
        }
        this.bc = null;
    }

    public void addConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        ServiceRegistration<?> old = this.commands.put(consoleCommandExtension, this.registerCommand(consoleCommandExtension));
        if (old != null) {
            this.unregisterCommand(old);
        }
    }

    public void removeConsoleCommandExtension(ConsoleCommandExtension consoleCommandExtension) {
        ServiceRegistration<?> old = this.commands.remove(consoleCommandExtension);
        if (old != null) {
            this.unregisterCommand(old);
        }
    }

    private Dictionary<String, Object> createProperties() {
        return new Properties();
    }

    private ServiceRegistration<?> registerCommand(ConsoleCommandExtension cmd) {
        if (this.bc == null) {
            return null;
        }
        Dictionary<String, Object> props = this.createProperties();
        props.put(KEY_SCOPE, SCOPE);
        props.put(KEY_FUNCTION, cmd.getCommand());
        try {
            ServiceRegistration serviceRegistration = this.bc.registerService(CommandWrapper.class.getName(), (Object)new CommandWrapper(cmd), props);
            return serviceRegistration;
        }
        catch (IllegalStateException illegalStateException) {
            this.logger.trace("Registration failed.");
            return null;
        }
    }

    private void unregisterCommand(ServiceRegistration<?> serviceRegistration) {
        try {
            serviceRegistration.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            this.logger.trace("Service already unregistered.");
        }
    }

    @Override
    public Collection<ConsoleCommandExtension> getConsoleCommandExtensions() {
        HashSet<ConsoleCommandExtension> set = new HashSet<ConsoleCommandExtension>();
        for (Map.Entry<ConsoleCommandExtension, ServiceRegistration<?>> entry : this.commands.entrySet()) {
            if (entry.getValue() == null) continue;
            set.add(entry.getKey());
        }
        return set;
    }
}

