/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.transport.mdns.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.eclipse.smarthome.io.transport.mdns.MDNSClient;
import org.eclipse.smarthome.io.transport.mdns.ServiceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNSClientImpl
implements MDNSClient {
    private final Logger logger = LoggerFactory.getLogger(MDNSClientImpl.class);
    private Set<JmDNS> jmdnsInstances = new CopyOnWriteArraySet<JmDNS>();

    /*
     * Unable to fully structure code
     */
    private static Set<InetAddress> getAllInetAddresses() {
        addresses = new HashSet<InetAddress>();
        try {
            itInterfaces = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl23
        }
        catch (SocketException e) {
            return addresses;
        }
        do {
            iface = itInterfaces.nextElement();
            try {
                if (!iface.isUp()) continue;
                if (iface.isLoopback()) {
                }
            }
            catch (SocketException ex) {}
            continue;
            itAddresses = iface.getInetAddresses();
            while (itAddresses.hasMoreElements()) {
                address = itAddresses.nextElement();
                if (address.isLoopbackAddress() || address.isLinkLocalAddress()) continue;
                addresses.add(address);
            }
lbl23:
            // 5 sources

        } while (itInterfaces.hasMoreElements());
        return addresses;
    }

    @Override
    public Set<JmDNS> getClientInstances() {
        return this.jmdnsInstances;
    }

    public void activate() {
        for (InetAddress address : MDNSClientImpl.getAllInetAddresses()) {
            try {
                JmDNS jmdns = JmDNS.create((InetAddress)address, (String)("JmDNS-IP-" + (this.jmdnsInstances.size() + 1)));
                this.jmdnsInstances.add(jmdns);
                this.logger.debug("mDNS service has been started ({} for IP {})", (Object)jmdns.getName(), (Object)address.getHostAddress());
            }
            catch (IOException e) {
                this.logger.debug("JmDNS instantiation failed ({})!", (Object)address.getHostAddress());
            }
        }
    }

    public void deactivate() {
        this.close();
    }

    @Override
    public void addServiceListener(String type, ServiceListener listener) {
        for (JmDNS instance : this.jmdnsInstances) {
            instance.addServiceListener(type, listener);
        }
    }

    @Override
    public void removeServiceListener(String type, ServiceListener listener) {
        for (JmDNS instance : this.jmdnsInstances) {
            instance.removeServiceListener(type, listener);
        }
    }

    @Override
    public void registerService(ServiceDescription description) throws IOException {
        for (JmDNS instance : this.jmdnsInstances) {
            this.logger.debug("Registering new service {} at {}:{} ({})", new Object[]{description.serviceType, instance.getInetAddress().getHostAddress(), description.servicePort, instance.getName()});
            ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
            instance.registerService(serviceInfo);
        }
    }

    @Override
    public void unregisterService(ServiceDescription description) {
        for (JmDNS instance : this.jmdnsInstances) {
            try {
                this.logger.debug("Unregistering service {} at {}:{} ({})", new Object[]{description.serviceType, instance.getInetAddress().getHostAddress(), description.servicePort, instance.getName()});
            }
            catch (IOException e) {
                this.logger.debug("Unregistering service {} ({})", (Object)description.serviceType, (Object)instance.getName());
            }
            ServiceInfo serviceInfo = ServiceInfo.create((String)description.serviceType, (String)description.serviceName, (int)description.servicePort, (int)0, (int)0, description.serviceProperties);
            instance.unregisterService(serviceInfo);
        }
    }

    @Override
    public void unregisterAllServices() {
        for (JmDNS instance : this.jmdnsInstances) {
            instance.unregisterAllServices();
        }
    }

    @Override
    public ServiceInfo[] list(String type) {
        ServiceInfo[] services = new ServiceInfo[]{};
        for (JmDNS instance : this.jmdnsInstances) {
            services = this.concatenate(services, instance.list(type));
        }
        return services;
    }

    @Override
    public void close() {
        for (JmDNS jmdns : this.jmdnsInstances) {
            try {
                jmdns.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ServiceInfo[] concatenate(ServiceInfo[] a, ServiceInfo[] b) {
        int aLen = a.length;
        int bLen = b.length;
        ServiceInfo[] c = new ServiceInfo[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }
}

