/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.script.ScriptEngine;
import org.eclipse.smarthome.automation.module.script.ScriptEngineFactory;
import org.eclipse.smarthome.automation.module.script.ScriptExtensionProvider;

public class ScriptExtensionManager {
    private static Set<ScriptExtensionProvider> scriptExtensionProviders = new CopyOnWriteArraySet<ScriptExtensionProvider>();

    public static Set<ScriptExtensionProvider> getScriptExtensionProviders() {
        return scriptExtensionProviders;
    }

    public void addScriptExtensionProvider(ScriptExtensionProvider provider) {
        scriptExtensionProviders.add(provider);
    }

    public void removeScriptExtensionProvider(ScriptExtensionProvider provider) {
        scriptExtensionProviders.remove(provider);
    }

    public static void addExtension(ScriptExtensionProvider provider) {
        scriptExtensionProviders.add(provider);
    }

    public static void removeExtension(ScriptExtensionProvider provider) {
        scriptExtensionProviders.remove(provider);
    }

    public static List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (ScriptExtensionProvider provider : scriptExtensionProviders) {
            types.addAll(provider.getTypes());
        }
        return types;
    }

    public static List<String> getPresets() {
        ArrayList<String> presets = new ArrayList<String>();
        for (ScriptExtensionProvider provider : scriptExtensionProviders) {
            presets.addAll(provider.getPresets());
        }
        return presets;
    }

    public static Object get(String type, String scriptIdentifier) {
        for (ScriptExtensionProvider provider : scriptExtensionProviders) {
            if (!provider.getTypes().contains(type)) continue;
            return provider.get(scriptIdentifier, type);
        }
        return null;
    }

    public static List<String> getDefaultPresets() {
        ArrayList<String> defaultPresets = new ArrayList<String>();
        for (ScriptExtensionProvider provider : scriptExtensionProviders) {
            defaultPresets.addAll(provider.getDefaultPresets());
        }
        return defaultPresets;
    }

    public static void importDefaultPresets(ScriptEngineFactory engineProvider, ScriptEngine scriptEngine, String scriptIdentifier) {
        for (String preset : ScriptExtensionManager.getDefaultPresets()) {
            ScriptExtensionManager.importPreset(preset, engineProvider, scriptEngine, scriptIdentifier);
        }
    }

    public static void importPreset(String preset, ScriptEngineFactory engineProvider, ScriptEngine scriptEngine, String scriptIdentifier) {
        for (ScriptExtensionProvider provider : scriptExtensionProviders) {
            if (!provider.getPresets().contains(preset)) continue;
            Map<String, Object> scopeValues = provider.importPreset(scriptIdentifier, preset);
            engineProvider.scopeValues(scriptEngine, scopeValues);
        }
    }

    public static void dispose(String scriptIdentifier) {
        for (ScriptExtensionProvider provider : scriptExtensionProviders) {
            provider.unload(scriptIdentifier);
        }
    }
}

