/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.common.SafeCallerBuilder;
import org.eclipse.smarthome.core.internal.common.SafeCallManagerImpl;
import org.eclipse.smarthome.core.internal.common.SafeCallerBuilderImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@NonNullByDefault
@Component(configurationPid="org.eclipse.smarthome.safecaller", immediate=true, configurationPolicy=ConfigurationPolicy.OPTIONAL)
public class SafeCallerImpl
implements SafeCaller {
    private static final String SAFE_CALL_POOL_NAME = "safeCall";
    @NonNullByDefault(value={})
    private ScheduledExecutorService watcher;
    @NonNullByDefault(value={})
    private SafeCallManagerImpl manager;

    @Activate
    public void activate(@Nullable Map<String, Object> properties) {
        this.watcher = Executors.newSingleThreadScheduledExecutor();
        this.manager = new SafeCallManagerImpl(this.watcher, this.getPoolName(), false);
        this.modified(properties);
    }

    @Modified
    public void modified(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            String enabled = (String)properties.get("singleThread");
            this.manager.setEnforceSingleThreadPerIdentifier("true".equalsIgnoreCase(enabled));
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.watcher != null) {
            this.watcher.shutdownNow();
            this.watcher = null;
        }
        this.manager = null;
    }

    @Override
    public <T> SafeCallerBuilder<T> create(T target, Class<T> interfaceType) {
        return new SafeCallerBuilderImpl<T>(target, new Class[]{interfaceType}, this.manager);
    }

    @Override
    public <T> SafeCallerBuilder<T> create(T target) {
        return new SafeCallerBuilderImpl<T>(target, SafeCallerImpl.getAllInterfaces(target), this.manager);
    }

    protected String getPoolName() {
        return SAFE_CALL_POOL_NAME;
    }

    private static <T> Class<?>[] getAllInterfaces(T target) {
        ArrayList ret = new ArrayList();
        Class<?> clazz = target.getClass();
        while (clazz != null) {
            ret.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return ret.toArray(new Class[ret.size()]);
    }
}

