/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.ComplexType;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;

public class HSBType
extends PercentType
implements ComplexType,
State,
Command {
    private static final long serialVersionUID = 322902950356613226L;
    public static final String KEY_HUE = "h";
    public static final String KEY_SATURATION = "s";
    public static final String KEY_BRIGHTNESS = "b";
    public static final HSBType BLACK = new HSBType("0,0,0");
    public static final HSBType WHITE = new HSBType("0,0,100");
    public static final HSBType RED = new HSBType("0,100,100");
    public static final HSBType GREEN = new HSBType("120,100,100");
    public static final HSBType BLUE = new HSBType("240,100,100");
    protected BigDecimal hue;
    protected BigDecimal saturation;

    public HSBType() {
        this("0,0,0");
    }

    public HSBType(DecimalType h, PercentType s, PercentType b) {
        this.hue = h.toBigDecimal();
        this.saturation = s.toBigDecimal();
        this.value = b.toBigDecimal();
    }

    public HSBType(String value) {
        String[] constituents;
        if (value != null) {
            constituents = value.split(",");
            if (constituents.length != 3) {
                throw new IllegalArgumentException(String.valueOf(value) + " is not a valid HSBType syntax");
            }
        } else {
            throw new IllegalArgumentException("Constructor argument must not be null");
        }
        this.hue = new BigDecimal(constituents[0]);
        this.saturation = new BigDecimal(constituents[1]);
        this.value = new BigDecimal(constituents[2]);
    }

    public static HSBType valueOf(String value) {
        return new HSBType(value);
    }

    public static HSBType fromRGB(int r, int g, int b) {
        float tmpHue;
        int min;
        int max;
        int n = max = r > g ? r : g;
        if (b > max) {
            max = b;
        }
        int n2 = min = r < g ? r : g;
        if (b < min) {
            min = b;
        }
        float tmpBrightness = (float)max / 2.55f;
        float tmpSaturation = (max != 0 ? (float)(max - min) / (float)max : 0.0f) * 100.0f;
        if (tmpSaturation == 0.0f) {
            tmpHue = 0.0f;
        } else {
            float red = (float)(max - r) / (float)(max - min);
            float green = (float)(max - g) / (float)(max - min);
            float blue = (float)(max - b) / (float)(max - min);
            tmpHue = r == max ? blue - green : (g == max ? 2.0f + red - blue : 4.0f + green - red);
            if ((tmpHue = tmpHue / 6.0f * 360.0f) < 0.0f) {
                tmpHue += 360.0f;
            }
        }
        return new HSBType(new DecimalType((int)tmpHue), new PercentType((int)tmpSaturation), new PercentType((int)tmpBrightness));
    }

    @Override
    public SortedMap<String, PrimitiveType> getConstituents() {
        TreeMap<String, PrimitiveType> map = new TreeMap<String, PrimitiveType>();
        map.put(KEY_HUE, this.getHue());
        map.put(KEY_SATURATION, this.getSaturation());
        map.put(KEY_BRIGHTNESS, this.getBrightness());
        return map;
    }

    public DecimalType getHue() {
        return new DecimalType(this.hue);
    }

    public PercentType getSaturation() {
        return new PercentType(this.saturation);
    }

    public PercentType getBrightness() {
        return new PercentType(this.value);
    }

    public PercentType getRed() {
        return this.toRGB()[0];
    }

    public PercentType getGreen() {
        return this.toRGB()[1];
    }

    public PercentType getBlue() {
        return this.toRGB()[2];
    }

    public int getRGB() {
        PercentType[] rgb = this.toRGB();
        return 0xFF000000 | (this.convertPercentToByte(rgb[0]) & 0xFF) << 16 | (this.convertPercentToByte(rgb[1]) & 0xFF) << 8 | (this.convertPercentToByte(rgb[2]) & 0xFF) << 0;
    }

    @Override
    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.getHue() + "," + this.getSaturation() + "," + this.getBrightness();
    }

    @Override
    public int hashCode() {
        int tmp = 10000 * (this.getHue() == null ? 0 : this.getHue().hashCode());
        tmp += 100 * (this.getSaturation() == null ? 0 : this.getSaturation().hashCode());
        return tmp += this.getBrightness() == null ? 0 : this.getBrightness().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HSBType)) {
            return false;
        }
        HSBType other = (HSBType)obj;
        if (this.getHue() != null && other.getHue() == null || this.getHue() == null && other.getHue() != null || this.getSaturation() != null && other.getSaturation() == null || this.getSaturation() == null && other.getSaturation() != null || this.getBrightness() != null && other.getBrightness() == null || this.getBrightness() == null && other.getBrightness() != null) {
            return false;
        }
        return this.getHue().equals(other.getHue()) && this.getSaturation().equals(other.getSaturation()) && this.getBrightness().equals(other.getBrightness());
    }

    public PercentType[] toRGB() {
        PercentType red = null;
        PercentType green = null;
        PercentType blue = null;
        BigDecimal h = this.hue.divide(BigDecimal.valueOf(100L), 10, 4);
        BigDecimal s = this.saturation.divide(BigDecimal.valueOf(100L));
        int h_int = h.multiply(BigDecimal.valueOf(5L)).divide(BigDecimal.valueOf(3L), 10, 4).intValue();
        BigDecimal f = h.multiply(BigDecimal.valueOf(5L)).divide(BigDecimal.valueOf(3L), 10, 4).remainder(BigDecimal.ONE);
        PercentType a = new PercentType(this.value.multiply(BigDecimal.ONE.subtract(s)));
        PercentType b = new PercentType(this.value.multiply(BigDecimal.ONE.subtract(s.multiply(f))));
        PercentType c = new PercentType(this.value.multiply(BigDecimal.ONE.subtract(BigDecimal.ONE.subtract(f).multiply(s))));
        if (h_int == 0 || h_int == 6) {
            red = this.getBrightness();
            green = c;
            blue = a;
        } else if (h_int == 1) {
            red = b;
            green = this.getBrightness();
            blue = a;
        } else if (h_int == 2) {
            red = a;
            green = this.getBrightness();
            blue = c;
        } else if (h_int == 3) {
            red = a;
            green = b;
            blue = this.getBrightness();
        } else if (h_int == 4) {
            red = c;
            green = a;
            blue = this.getBrightness();
        } else if (h_int == 5) {
            red = this.getBrightness();
            green = a;
            blue = b;
        } else {
            throw new RuntimeException();
        }
        return new PercentType[]{red, green, blue};
    }

    private int convertPercentToByte(PercentType percent) {
        return percent.value.multiply(BigDecimal.valueOf(255L)).divide(BigDecimal.valueOf(100L), 2, 4).intValue();
    }

    @Override
    public State as(Class<? extends State> target) {
        if (target == OnOffType.class) {
            return this.getBrightness().equals(PercentType.ZERO) ? OnOffType.OFF : OnOffType.ON;
        }
        if (target == DecimalType.class) {
            return new DecimalType(this.getBrightness().toBigDecimal().divide(BigDecimal.valueOf(100L), 8, RoundingMode.UP));
        }
        if (target == PercentType.class) {
            return new PercentType(this.getBrightness().toBigDecimal());
        }
        return this.defaultConversion(target);
    }
}

