/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public class PercentType
extends DecimalType {
    private static final long serialVersionUID = -9066279845951780879L;
    public static final PercentType ZERO = new PercentType(0);
    public static final PercentType HUNDRED = new PercentType(100);

    public PercentType() {
        this(0);
    }

    public PercentType(int value) {
        super(value);
        this.validateValue(this.value);
    }

    public PercentType(String value) {
        super(value);
        this.validateValue(this.value);
    }

    public PercentType(BigDecimal value) {
        super(value);
        this.validateValue(this.value);
    }

    private void validateValue(BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(value) > 0 || BigDecimal.valueOf(100L).compareTo(value) < 0) {
            throw new IllegalArgumentException("Value must be between 0 and 100");
        }
    }

    public static PercentType valueOf(String value) {
        return new PercentType(value);
    }

    @Override
    public State as(Class<? extends State> target) {
        if (target == OnOffType.class) {
            return this.equals(ZERO) ? OnOffType.OFF : OnOffType.ON;
        }
        if (target == DecimalType.class) {
            return new DecimalType(this.toBigDecimal().divide(BigDecimal.valueOf(100L), 8, RoundingMode.UP));
        }
        if (target == UpDownType.class) {
            if (this.equals(ZERO)) {
                return UpDownType.UP;
            }
            if (this.equals(HUNDRED)) {
                return UpDownType.DOWN;
            }
            return UnDefType.UNDEF;
        }
        if (target == OpenClosedType.class) {
            if (this.equals(ZERO)) {
                return OpenClosedType.CLOSED;
            }
            if (this.equals(HUNDRED)) {
                return OpenClosedType.OPEN;
            }
            return UnDefType.UNDEF;
        }
        if (target == HSBType.class) {
            return new HSBType(DecimalType.ZERO, ZERO, this);
        }
        return this.defaultConversion(target);
    }
}

