/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.text.ParseException;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.smarthome.core.scheduler.ExpressionPart;

abstract class AbstractExpressionPart
implements ExpressionPart {
    private String part;
    private BoundedIntegerSet valueSet;

    public AbstractExpressionPart(String s) throws ParseException {
        this.set(s);
        this.parse();
    }

    @Override
    public void set(String s) {
        this.setPart(s);
    }

    public BoundedIntegerSet getValueSet() {
        return this.valueSet;
    }

    public void setValueSet(BoundedIntegerSet set) {
        this.valueSet = set;
    }

    abstract BoundedIntegerSet initializeValueSet();

    @Override
    public abstract int order();

    @Override
    public int compareTo(ExpressionPart o) {
        if (this.order() < o.order()) {
            return -1;
        }
        if (this.order() < o.order()) {
            return 1;
        }
        return 0;
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    protected class BoundedIntegerSet
    extends TreeSet<Integer> {
        private static final long serialVersionUID = 19296179649170335L;
        protected final int max;
        protected final int min;
        protected final boolean negative;
        protected boolean is1indexed;

        BoundedIntegerSet(int min, int max, boolean negativeValuesAllowed, boolean is1indexed) {
            this.min = min;
            this.max = max;
            this.negative = negativeValuesAllowed;
            this.is1indexed = is1indexed;
        }

        private void validate(Integer integer) {
            if (this.negative) {
                int abs = Math.abs(integer);
                if (abs < this.min || abs > this.max) {
                    throw new IllegalArgumentException("Invalid integer value (value not in range [" + -this.max + ", " + -this.min + "] U [" + this.min + ", " + this.max + "])");
                }
            } else if (integer < this.min || integer > this.max) {
                throw new IllegalArgumentException("Invalid integer value (value not in range [" + this.min + ", " + this.max + "])");
            }
        }

        @Override
        public boolean add(Integer e) {
            this.validate(e);
            return super.add(e);
        }

        public boolean add(Integer start, Integer end, Integer increment) {
            if (end != null && end > this.max) {
                throw new IllegalArgumentException("Invalid integer value (end not in range [" + this.min + ", " + this.max + "])");
            }
            if (start != null && start < this.min) {
                throw new IllegalArgumentException("Invalid integer value (start not in range [" + this.min + ", " + this.max + "])");
            }
            int stopAt = end == null ? this.max : end;
            int startAt = start == null ? this.min : start;
            boolean overflow = false;
            if (stopAt < startAt) {
                stopAt += this.max;
                overflow = true;
            }
            int i = startAt;
            while (i <= stopAt) {
                if (!overflow) {
                    this.add(i);
                } else {
                    int i2 = i % this.max;
                    if (i2 == 0 && this.is1indexed) {
                        i2 = this.max;
                    }
                    this.add(i2);
                }
                i += increment.intValue();
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            for (Integer n : c) {
                this.validate(n);
            }
            return super.addAll(c);
        }
    }
}

