/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.auth;

import com.eclipsesource.jaxrs.provider.security.AuthenticationHandler;
import com.eclipsesource.jaxrs.provider.security.AuthorizationHandler;
import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;
import org.eclipse.smarthome.core.auth.Authentication;
import org.eclipse.smarthome.core.auth.AuthenticationProvider;
import org.eclipse.smarthome.core.auth.Credentials;
import org.eclipse.smarthome.io.rest.auth.internal.SmartHomePrincipal;

public abstract class AbstractSecurityHandler
implements AuthenticationHandler,
AuthorizationHandler {
    private AuthenticationProvider authenticationProvider;

    public final boolean isUserInRole(Principal user, String role) {
        if (user instanceof SmartHomePrincipal) {
            return ((SmartHomePrincipal)user).getRoles().contains(role);
        }
        return false;
    }

    public Principal authenticate(ContainerRequestContext requestContext) {
        if (this.authenticationProvider == null) {
            return null;
        }
        Credentials credentials = this.createCredentials(requestContext);
        if (credentials == null) {
            return null;
        }
        Authentication authentication = this.authenticationProvider.authenticate(credentials);
        if (authentication != null) {
            return new SmartHomePrincipal(authentication);
        }
        return null;
    }

    protected abstract Credentials createCredentials(ContainerRequestContext var1);

    protected void setAuthenticationService(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    protected void unsetAuthenticationService(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = null;
    }
}

