/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.smarthome.binding.lifx.handler.LifxLightHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightCommunicationHandler;
import org.eclipse.smarthome.binding.lifx.internal.LifxLightContext;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetColorZonesRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLightInfraredRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetWifiInfoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Products;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLightInfraredResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLightPowerResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateMultiZoneResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StatePowerResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateWifiInfoResponse;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxMessageUtil;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifxLightCurrentStateUpdater {
    private static final int STATE_POLLING_INTERVAL = 3;
    private final Logger logger = LoggerFactory.getLogger(LifxLightCurrentStateUpdater.class);
    private final String logId;
    private final Products product;
    private final LifxLightHandler.CurrentLightState currentLightState;
    private final ScheduledExecutorService scheduler;
    private final LifxLightCommunicationHandler communicationHandler;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean wasOnline;
    private boolean updateSignalStrength;
    private ScheduledFuture<?> statePollingJob;

    public LifxLightCurrentStateUpdater(LifxLightContext context, LifxLightCommunicationHandler communicationHandler) {
        this.logId = context.getLogId();
        this.product = context.getProduct();
        this.currentLightState = context.getCurrentLightState();
        this.scheduler = context.getScheduler();
        this.communicationHandler = communicationHandler;
    }

    public void pollLightState() {
        try {
            try {
                this.lock.lock();
                if (this.currentLightState.isOnline()) {
                    this.logger.trace("{} : Polling the state of the light", (Object)this.logId);
                    this.sendLightStateRequests();
                } else {
                    this.logger.trace("{} : The light is not online, there is no point polling it", (Object)this.logId);
                }
                this.wasOnline = this.currentLightState.isOnline();
            }
            catch (Exception e) {
                this.logger.error("Error occurred while polling light state", (Throwable)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUpdateSignalStrength(boolean updateSignalStrength) {
        this.updateSignalStrength = updateSignalStrength;
    }

    public void start() {
        try {
            try {
                this.lock.lock();
                this.communicationHandler.addResponsePacketListener(this::handleResponsePacket);
                if (this.statePollingJob == null || this.statePollingJob.isCancelled()) {
                    this.statePollingJob = this.scheduler.scheduleWithFixedDelay(this::pollLightState, 0L, 3L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                this.logger.error("Error occurred while starting light state updater", (Throwable)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        try {
            try {
                this.lock.lock();
                this.communicationHandler.removeResponsePacketListener(this::handleResponsePacket);
                if (this.statePollingJob != null && !this.statePollingJob.isCancelled()) {
                    this.statePollingJob.cancel(true);
                    this.statePollingJob = null;
                }
            }
            catch (Exception e) {
                this.logger.error("Error occurred while stopping light state updater", (Throwable)e);
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void sendLightStateRequests() {
        this.communicationHandler.sendPacket(new GetRequest());
        if (this.product.isInfrared()) {
            this.communicationHandler.sendPacket(new GetLightInfraredRequest());
        }
        if (this.product.isMultiZone()) {
            this.communicationHandler.sendPacket(new GetColorZonesRequest());
        }
        if (this.updateSignalStrength) {
            this.communicationHandler.sendPacket(new GetWifiInfoRequest());
        }
    }

    public void handleResponsePacket(Packet packet) {
        try {
            this.lock.lock();
            if (packet instanceof StateResponse) {
                this.handleLightStatus((StateResponse)packet);
            } else if (packet instanceof StatePowerResponse) {
                this.handlePowerStatus((StatePowerResponse)packet);
            } else if (packet instanceof StateLightPowerResponse) {
                this.handleLightPowerStatus((StateLightPowerResponse)packet);
            } else if (packet instanceof StateLightInfraredResponse) {
                this.handleInfraredStatus((StateLightInfraredResponse)packet);
            } else if (packet instanceof StateMultiZoneResponse) {
                this.handleMultiZoneStatus((StateMultiZoneResponse)packet);
            } else if (packet instanceof StateWifiInfoResponse) {
                this.handleWifiInfoStatus((StateWifiInfoResponse)packet);
            }
            this.currentLightState.setOnline();
            if (this.currentLightState.isOnline() && !this.wasOnline) {
                this.wasOnline = true;
                this.logger.trace("{} : The light just went online, immediately polling the state of the light", (Object)this.logId);
                this.sendLightStateRequests();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleLightStatus(StateResponse packet) {
        this.currentLightState.setColor(packet.getColor(), 0);
        this.currentLightState.setPowerState(packet.getPower());
    }

    private void handlePowerStatus(StatePowerResponse packet) {
        this.currentLightState.setPowerState(packet.getState());
    }

    private void handleLightPowerStatus(StateLightPowerResponse packet) {
        this.currentLightState.setPowerState(packet.getState());
    }

    private void handleInfraredStatus(StateLightInfraredResponse packet) {
        PercentType infrared = LifxMessageUtil.infraredToPercentType(packet.getInfrared());
        this.currentLightState.setInfrared(infrared);
    }

    private void handleMultiZoneStatus(StateMultiZoneResponse packet) {
        HSBK[] colors = this.currentLightState.getColors();
        if (colors == null || colors.length != packet.getCount()) {
            colors = new HSBK[packet.getCount()];
        }
        int i = 0;
        while (i < packet.getColors().length && packet.getIndex() + i < colors.length) {
            colors[packet.getIndex() + i] = packet.getColors()[i];
            ++i;
        }
        this.currentLightState.setColors(colors);
    }

    private void handleWifiInfoStatus(StateWifiInfoResponse packet) {
        this.currentLightState.setSignalStrength(packet.getSignalStrength());
    }
}

