/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.fields;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;

public class LittleField<T>
extends Field<T> {
    private final Field<T> wrapped;

    public LittleField(Field<T> wrapped) {
        super(wrapped.length);
        this.wrapped = wrapped;
    }

    @Override
    public int defaultLength() {
        return this.wrapped.defaultLength();
    }

    @Override
    public T value(ByteBuffer bytes) {
        byte[] field = new byte[this.wrapped.length];
        bytes.get(field);
        ByteBuffer flipped = LittleField.flip(ByteBuffer.wrap(field));
        T value = this.wrapped.value(flipped);
        return value;
    }

    @Override
    public ByteBuffer bytesInternal(T value) {
        return LittleField.flip(this.wrapped.bytes(value));
    }

    public static ByteBuffer flip(ByteBuffer buf) {
        buf.rewind();
        ByteBuffer ret = ByteBuffer.allocate(buf.limit());
        int i = buf.limit() - 1;
        while (i >= 0) {
            ret.put(buf.get(i));
            --i;
        }
        ret.rewind();
        return ret;
    }
}

