/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.fields;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;

public class MACAddressField
extends Field<MACAddress> {
    public MACAddressField() {
        super(8);
    }

    @Override
    public int defaultLength() {
        return 8;
    }

    @Override
    public MACAddress value(ByteBuffer bytes) {
        byte[] data = new byte[this.length];
        bytes.get(data);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.limit(this.length - 2);
        return new MACAddress(buffer);
    }

    @Override
    protected ByteBuffer bytesInternal(MACAddress value) {
        return value.getBytes().duplicate();
    }

    @Override
    public ByteBuffer bytes(MACAddress value) {
        byte[] data = new byte[this.length];
        ByteBuffer bytes = this.bytesInternal(value);
        bytes.rewind();
        bytes.get(data, 0, bytes.limit());
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.rewind();
        return buf;
    }
}

